import req from '@/request'

const portal = window.context.portal

export function tableData(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/bizBaseFiles/v1/query`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

export function tableAdd(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/bizBaseFiles/v1/`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

export function tableEdit(data) {
  return new Promise((resolve, reject) => {
    req.put(portal + `/bizBaseFiles/v1/`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

export function tableDelete(ids) {
  return new Promise((resolve, reject) => {
    req.remove(portal + `/bizBaseFiles/v1/?ids=${ids}`)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 表格详情
export function tableDetail(id) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/bizBaseFiles/v1/${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

