/*
* ✨ 统一门户系统菜单方法 ✨
* */

import { generateTokenKey } from '@/api/homePage'
import router from '@/router/router'
import store from '@/store'
import { Message } from 'element-ui'

/**
 * @description: 格式化系统图标
 * @param { String } name 系统名称
 * @return { String } 系统图标简写
 */
export function formatSystemIconImg(name) {
  let iconName = 'jsc'
  if (name.indexOf('养护') !== -1) {
    iconName = 'yh'
  } else if (name.indexOf('安全') !== -1) {
    iconName = 'aq'
  } else if (name.indexOf('巡查') !== -1) {
    iconName = 'xc'
  } else if (name.indexOf('机电') !== -1) {
    iconName = 'jd'
  } else if (name.indexOf('收费') !== -1) {
    iconName = 'sf'
  } else if (name.indexOf('视频') !== -1) {
    iconName = 'sp'
  } else if (name.indexOf('主数据') !== -1) {
    iconName = 'zsj'
  } else if (name.indexOf('共享交换') !== -1) {
    iconName = 'sjgx'
  }
  return iconName
}

/**
 * @description: 返回第一个子路由
 * @param { Array } routes  路由列表
 * @return { Object || null }  第一个子路由
 */
export function processFirstChild(routes) {
  for (const item of routes) {
    if (item.children && item.children.length) {
      return processFirstChild(item.children)
    } else {
      return item
    }
  }
  return null
}

/**
 * @description: 系统跳转方法 根据各系统特点、跳转方式各异
 * @param { Object} menu
 * @return void
 */
export async function systemJump(menu) {
  const tokenKey = await processTokenKey()  // 获取tokenKey
  console.log(tokenKey)

  if (menu.alias === 'homePage') {
    /* 处理首页跳转 */

    router.push('/platLayout/homePage')

  } else if (menu.name === '领导驾驶舱') {
    /* 处理驾驶舱跳转 */

    const { code, path } = processMenu(menu) // 解析菜单code和path

    let query = `code=${code}&ptk=${tokenKey}`
    const linkPath = path + '?' + query
    window.open(linkPath, '_blank')

  } else if (menu.name.indexOf('安全') !== -1 || menu.name.indexOf('巡查') !== -1 || menu.name.indexOf('养护') !== -1 || menu.name.indexOf('共享交换') !== -1) {
    /*  处理安全/巡查/养护跳转  */

    const linkPath = menu.href + '?ptk=' + tokenKey
    window.open(linkPath, '_blank')

  } else if (menu.alias === "MasterDataSystem") {
    /*  处理主数据跳转  */

    // 跳第一个子路由
    // const MasterDataSystem = await store.dispatch('menu/actionFrontMenus')
    // const path = processRoutingFirstChild(MasterDataSystem, '')

    // router.push('/platLayout/' + path)

    // 跳主数据系统首页
    router.push('/platLayout/MasterDataSystem')

  } else {
    Message.error('抱歉，您没有权限访问该功能！')
  }
}

/**
 * @description: 获取tokenKey
 * @return { String } tokenKey
 */
export function processTokenKey() {
  return new Promise((resolve, reject) => {
    generateTokenKey()
      .then(res => {
        if (res) {
          resolve(res.value || '')
        }
      })
      .catch(err => {
        reject(err)
      })
  })
}

/**
 * @description: 解析系统菜单code和path
 * @param { Object } menu 系统菜单
 * @return { Object } 系统菜单code和path
 */
export function processMenu(menu) {
  const code = menu.href.split('#/')[1] || ''
  const path = menu.href.split('#/')[0] || ''
  return { code, path }
}


/**
 * @description: 递归处理路由，返回第一个子路由的路径
 * @param { Array } routes 路由列表
 * @param { String } fullPath 父路由路径
 * @return { String } 第一个子路由的路径
 */

export function processRoutingFirstChild(routes, fullPath = '') {
  // 去除 fullPath 开头和结尾的多余斜杠
  fullPath = fullPath.replace(/^\/+|\/+$/g, '');

  for (const item of routes) {
    let currentPath = fullPath;
    // 如果 item 有 alias，拼接到 currentPath
    if (item.alias) {
      currentPath = `${currentPath}/${item.alias}`;
    }
    // 递归处理子路由
    if (item.children && item.children.length) {
      const childPath = processRoutingFirstChild(item.children, currentPath);
      // 只有在需要返回时才进行替换操作
      return childPath.replace(/\/+/g, '/');
    } else {
      return currentPath;
    }
  }
  // 如果 routes 为空，返回空字符串
  return '';
}

