// src/store/index.js
import Vue from 'vue';
import Vuex from 'vuex';

Vue.use(Vuex);

export default new Vuex.Store({
  state: {
    eventVisible: false,
    detailVisible: false
  },
  mutations: {
    setEventVisible(state, value) {
      state.eventVisible = value;
    },
    setDetailVisible(state, value) {
      state.detailVisible = value;
    }
  },
  actions: {
    updateEventVisible({ commit }, value) {
      commit('setEventVisible', value);
    },
    updateDetailVisible({ commit }, value) {
      commit('setDetailVisible', value);
    }

  },
  getters: {
    // getEventVisible: state => state.eventVisible,
    // getDetailVisible: state => state.detailVisible
  }
});