import Vue from 'vue'
import Router from 'vue-router'
import store from '@/store'
import NotFound from '@/views/systemDefaultPage/NotFound.vue'
import Login from '@/views/Login/index.vue'
import aiPage from '@/views/systemDefaultPage/Ai.vue'
import req from '@/request'
import uc from '@/api/uc.js'
import portal from '@/api/portal.js'
//路由
import mainRouter from '@/router/module-router'// 主数据模块路由
import customSystemRouter from '@/router/custom-system-router' // 自定义路由
import Layout from '@/components/layout/Layout.vue'
// 消息组件
import { Message } from 'element-ui'

import SparkMD5 from 'spark-md5'


Vue.use(Router)

const router = new Router({
  mode: 'history',
  base: process.env.BASE_URL,
  routes: [
    // 重定向到login
    {
      path: '/',
      redirect: {
        name: 'login'
      }
    },
    // 登录页面
    {
      path: '/login',
      name: 'login',
      component: Login,
      meta: {
        single: true,
        anonymous: true
      }
    },
    // AI界面
    {
      path: '/aiPage',
      name: 'aiPage',
      component: aiPage,
      meta: {
        single: true,
        anonymous: true
      }
    },
    // 主数据后台页面
    {
      path: '/platLayout',
      name: 'platLayout',
      component: () => import('@/components/layout/Layout.vue'),
      meta: {
        single: true,
        anonymous: true
      },
      children: [
        // 自定义前台路由
        ...customSystemRouter,
        // 需要在系统菜单中配置的路由
        ...mainRouter,
        // 404页面
        {
          path: '/:catchAll(.*)',
          component: NotFound,
          meta: {
            // single: true
          }
        }
      ]
    },

    // 404页面
    {
      path: '/:catchAll(.*)',
      component: NotFound,
      meta: {
        // single: true
      }
    },
  ]
})


const createRouter = () =>
  new Router({
    mode: 'history',
    routes: []
  })

//重写动态添加路由方法
router.$addRoutes = params => {
  const newRouter = createRouter()
  router.matcher = newRouter.matcher //重置路由规则
  router.addRoutes(params) // 添加路由
}

//动态新增二级路由
router.addList = () => false


let registerRouteFresh = true

const ssoRedirect = () => {
  if (window.ssoConfig.mode === 'cas') {
    let service = window.location.href
    localStorage.setItem('service', service)
    window.location.href = window.ssoConfig.url + '?service=' + service
  } else if (window.ssoConfig.mode === 'oauth') {
    if (!window.ssoConfig.clientId) {
      throw 'oauth模式下必须提供clientId'
    }
    const service = window.location.href
    localStorage.setItem('service', service)
    window.location.href = `${window.ssoConfig.url}?response_type=code&client_id=${window.ssoConfig.clientId}&redirect_uri=${service}`
  }
}

const handelShortUrl = (to, from, next) => {
  req
    .get(
      '${portal}/portal/shorturlManage/v1/getLongUrlByShortUrl?shortUrl=' +
      to.fullPath.substr(1),
      '',
      false
    )
    .then(resp => {
      if (resp && resp.data && resp.data.state) {
        store
          .dispatch(
            'login/validAndCompletedCurrent',
            resp.data.value.guestToken
          )
          .then(() => {
            next({
              path: resp.data.value.url
            })
          })
          .catch(() => {
            logoutAndCleanUp(to, from, next)
          })
      } else {
        next({
          path: '/messageFillPage/' + resp.data.message
        })
      }
    })
    .catch(() => {
      logoutAndCleanUp(to, from, next)
    })
}

const logoutAndCleanUp = (to, from, next) => {
  store.dispatch('login/logoutAndCleanUp').then(() => {
    if (window.ssoConfig.mode && window.ssoConfig.mode !== 'jwt') {
      ssoRedirect()
    } else if (!window.ssoConfig.mode || window.ssoConfig.mode === 'jwt') {
      next({
        path: '/login'
        // query: {
        //     redirect: to.fullPath
        // }
      })
    } else {
      throw '登录失败'
    }
  })
}

const decodeToken = (key) => {
  let sparkStr = ''
  let spark = new SparkMD5()
  spark.append(key)
  sparkStr = spark.end()

  console.log('sparkStr', sparkStr)

  let Base64 = require('js-base64').Base64
  let token = Base64.encode(sparkStr);

  return token
}

const tokenLoginBigScreen = (userInfo, next, name) => {
  store.dispatch('login/loginByPrincipal', userInfo).then((loginStatus) => {
    if (loginStatus && loginStatus == true) {
      portal.getSysDict().then((data) => {
        if (data) {
          sessionStorage.setItem(
            'dict_data',
            JSON.stringify(data)
          )
        }
        if (name === 'safety') {
          next({
            path: '/safetyManageScreen'
          })
        }
      })
    }
  })
}

router.beforeEach(async (to, from, next) => {

  store.dispatch('menu/getAllmenus', {}).then(menus => {
    if (to.fullPath.indexOf('href') === -1) {
      let alias = to.fullPath.split('/')[1]
      for (let i = 0; i < menus.length; i++) {
        if (menus[i].alias === alias) {
          store.dispatch('menu/getCurrentMenu', {
            alias: menus[i].alias,
            name: menus[i].name
          })
          break
        }
      }
    }
  })

  if (to.fullPath.startsWith('/surl/')) {
    handelShortUrl(to, from, next)
    return
  }

  // 1.当前为单点登录模式，且要路由到login页面，则做单点登录重定向；
  if (
    to.name === 'login' &&
    window.ssoConfig.mode &&
    window.ssoConfig.mode !== 'jwt'
  ) {
    // 单点登录时如果已经携带了code或者ticket时，如果是/login路径需要跳转到默认页面（解决反复跳转的问题）
    if (
      (window.ssoConfig.mode === 'cas' || window.ssoConfig.mode === 'oauth') &&
      (to.query.code || to.query.ticket)
    ) {
      window.location.href = window.location.href.replace('/login', '')
      return
    } else {
      ssoRedirect()
    }
  }

  if (from.name !== 'defStart' || to.name !== 'instStart') {
    sessionStorage.removeItem('formImportTempRefId')
    sessionStorage.removeItem('formImportTempJson')
  }

  if (
    sessionStorage.menu_alias &&
    to.fullPath &&
    to.fullPath.split('/')[1] === 'home'
  ) {
    sessionStorage.menu_alias = ''
  }
  if (to.matched.some(record => !record.meta.anonymous)) {
    let ticket = to.query.token
    // 2.当前已经从单点页面重定向回来了，且在url地址中携带了ticket或code；
    if (window.ssoConfig.mode === 'cas') {
      ticket = to.query.ticket
    } else if (window.ssoConfig.mode === 'oauth') {
      ticket = to.query.code
    }

    store
      // 3.携带ticket做用户鉴权；
      .dispatch('login/validAndCompletedCurrent', ticket)
      .then(() => {
        store.dispatch('menu/actionFrontMenus')
        store._vm.$root.$emit('login-completed')

        if (registerRouteFresh) {
          if (sessionStorage.menu_alias) {
            let path = '/' + sessionStorage.menu_alias
            let isChildren = router.addList(path, router.options.routes) //动态新增二级路由
            //当前点击菜单的路由别名不存在 router.js 里面
            // if (!isChildren) {
            //   let alias_new = {
            //     path: path,
            //     name: 'alias_new',
            //     component: resolve =>
            //       require(['@/views/menuContent.vue'], resolve),
            //     children: []
            //   }
            //   router.options.routes.push(alias_new)
            //   router.addList(path, router.options.routes) //动态新增二级路由
            // }
            router.replace({
              path: to.path,
              query: to.query
            })
          }
          registerRouteFresh = false
        }
        next()
        // url地址带token的方式认证成功后删除url中的token
        // removeUrlParams('tokenKey')
      })
      .catch(() => {
        // 4.鉴权失败时根据当前模式重定向到对应页面。
        logoutAndCleanUp(to, from, next)
      })
  } else {
    next()
  }
})

export default router
