import req from '@/request'
import {createAutoCancelRequest} from '@/utils/helpers'

const portal = window.context.portal

// 表格分页
export function tableData(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/bizBasePatrol/v1/query`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 表格详情
export function tableDetail(id) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/bizBasePatrol/v1/${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格新增
export function tableAdd(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/bizBasePatrol/v1/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格删除
export function tableDelete(ids) {
  return new Promise((resolve, reject) => {
    req.remove(portal + `/bizBasePatrol/v1/?ids=${ids}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格修改
export function tableEdit(data) {
  return new Promise((resolve, reject) => {
    req.put(portal + `/bizBasePatrol/v1/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

/**
 * 获取点位树信息
 * */
// export const pointTreeData = createAutoCancelRequest({
//   method: 'POST',
//   url: '/bizBasePatrol/v1/tree'
// })

export function pointTreeData(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/bizBasePatrol/v1/tree`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}
