import req from '@/request'

const portal = window.context.portal

// 表格分页
export function tableData(data) {
    return new Promise((resolve, reject) => {
        req.post(portal + `/bizBaseRoad/v1/query`, data)
            .then(res => resolve(res?.data || []))
            .catch(err => reject(err))
    })
}

// 同步数据
export function synchroData() {
    return new Promise((resolve, reject) => {
      req.get(portal + `/bizBaseRoad/v1/SynchronizeData`)
        .then(res => resolve(res?.data || {}))
        .catch(err => reject(err))
    })
}

// 表格详情
export function tableDetail(id) {
    return new Promise((resolve, reject) => {
      req.get(portal + `/bizBaseRoad/v1/${id}`)
        .then(res => resolve(res?.data || {}))
        .catch(err => reject(err))
    })
}

// 获取组织架构
export function getTree() {
    return new Promise((resolve, reject) => {
        req.get(portal + `/road/roadmanage/v1/roadTree`)
            .then(res => resolve(res?.data || []))
            .catch(err => reject(err))
    })
}