import req from "@/request";
const portal = window.context.portal;

// 工单新增
export function ticketsHaveBeenAdded(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/home/systemWorkOrder/v1/`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 工单列表
export function listOfTickets(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/home/systemWorkOrder/v1/query`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 工单详情
export function ticketDetails(id) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/home/systemWorkOrder/v1/${id}`)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 工单更新
export function updateHandlingStatus(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/home/systemWorkOrder/v1/updateHandlingStatus`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}
