import req from '@/request'

const portal = window.context.portal

// 资源申请-列表
export function putInTableData(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/bizCloudApply/v1/query`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 资源审核/资源执行-列表 审核（status=10）执行（status=30）
export function auditTableData(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/bizCloudApply/v1/query/todo`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 获取云资源使用情况
export function getCloudUseage(data) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/bizCloudApplyUseDetailed/v1/latest`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 保存
export function saveApply(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/bizCloudApply/v1/save`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

export function getApply(id) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/bizCloudApply/v1/getInfo/${id}`)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

export function getApplyDetail(id) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/bizCloudApplyDetail/v1/list/${id}`)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

export function deleteApplyDetail(ids) {
  return new Promise((resolve, reject) => {
    req.remove(portal + `/bizCloudApplyDetail/v1/?ids=${ids}`)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

export function downloadApply(id) {
  return new Promise((resolve, reject) => {
    req.downloadGet(portal + `/bizCloudApply/v1/export/${id}`)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

export function deleteApplyList(ids) {
  return new Promise((resolve, reject) => {
    req.remove(portal + `/bizCloudApply/v1/?ids=${ids}`)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

export function getRecordDetail(id) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/bizCloudApplyApprovalRecord/v1/getRecord/${id}`)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

export function downLoadUpload(bizPath,id) {
  return new Promise((resolve, reject) => {
    req.downloadGetCopy(portal + `/bizAccessory/v1/minIoAllDownFile?bizPath=${bizPath}&ids=${id}`)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

export function applyApproval(type,data) {
  // type -- start 发起 agree 同意 reject 驳回 complete 完成
  return new Promise((resolve, reject) => {
    req.post(portal + `/bizCloudApplyApprovalRecord/v1/${type}`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

export function addApplyDetail(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/bizCloudApplyDetail/v1/save`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

export function editApplyDetail(data) {
  return new Promise((resolve, reject) => {
    req.put(portal + `/bizCloudApplyDetail/v1/update`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

export function deleteDetailPorts(id) {
  return new Promise((resolve, reject) => {
    req.remove(portal + `/bizCloudApplyDetailPort/v1/${id}`)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}
