import req from '@/request'
const portal = window.context.portal

export function generateTokenKey() {
  return new Promise((resolve, reject) => {
    req
      .get(portal + `/application/server/generateTokenKey`)
      .then(res => {
        resolve(res?.data || {})
      })
      .catch(err => {
        reject(err)
      })
  })
}

export function getUserRegister(data) {
  return new Promise((resolve, reject) => {
    req
      .post(portal + `/userCenter/loginLog/v1/query`, data)
      .then(res => {
        resolve(res?.data || {})
      })
      .catch(err => {
        reject(err)
      })
  })
}

export function getFileData(data) {
  return new Promise((resolve, reject) => {
    req
      .post(portal + `/file/v1/list`, data)
      .then(res => {
        resolve(res?.data || {})
      })
      .catch(err => {
        reject(err)
      })
  })
}

export function fileDownload(fileld) {
  return new Promise((resolve, reject) => {
    req
      .downloadGet(portal + `/file/v1/downloadFile?fileId=${fileld}`)
      .then(res => {
        resolve(res?.data || {})
      })
      .catch(err => {
        reject(err)
      })
  })
}

export function fileDetele(id) {
  return new Promise((resolve, reject) => {
    req
      .remove(portal + `/file/v1/${id}`)
      .then(res => {
        resolve(res?.data || {})
      })
      .catch(err => {
        reject(err)
      })
  })
}
