"use strict";

const conversions = require("webidl-conversions");
const utils = require("./utils.js");

const convertNode = require("./Node.js").convert;
const convertMutationObserverInit = require("./MutationObserverInit.js").convert;
const impl = utils.implSymbol;

class MutationObserver {
  constructor(callback) {
    if (arguments.length < 1) {
      throw new TypeError(
        "Failed to construct 'MutationObserver': 1 argument required, but only " + arguments.length + " present."
      );
    }
    const args = [];
    {
      let curArg = arguments[0];
      curArg = utils.tryImplForWrapper(curArg);
      args.push(curArg);
    }
    return iface.setup(Object.create(new.target.prototype), args);
  }

  observe(target) {
    if (!this || !module.exports.is(this)) {
      throw new TypeError("Illegal invocation");
    }

    if (arguments.length < 1) {
      throw new TypeError(
        "Failed to execute 'observe' on 'MutationObserver': 1 argument required, but only " +
          arguments.length +
          " present."
      );
    }
    const args = [];
    {
      let curArg = arguments[0];
      curArg = convertNode(curArg, { context: "Failed to execute 'observe' on 'MutationObserver': parameter 1" });
      args.push(curArg);
    }
    {
      let curArg = arguments[1];
      curArg = convertMutationObserverInit(curArg, {
        context: "Failed to execute 'observe' on 'MutationObserver': parameter 2"
      });
      args.push(curArg);
    }
    return this[impl].observe(...args);
  }

  disconnect() {
    if (!this || !module.exports.is(this)) {
      throw new TypeError("Illegal invocation");
    }

    return this[impl].disconnect();
  }

  takeRecords() {
    if (!this || !module.exports.is(this)) {
      throw new TypeError("Illegal invocation");
    }

    return utils.tryWrapperForImpl(this[impl].takeRecords());
  }
}
Object.defineProperties(MutationObserver.prototype, {
  observe: { enumerable: true },
  disconnect: { enumerable: true },
  takeRecords: { enumerable: true },
  [Symbol.toStringTag]: { value: "MutationObserver", configurable: true }
});
const iface = {
  // When an interface-module that implements this interface as a mixin is loaded, it will append its own `.is()`
  // method into this array. It allows objects that directly implements *those* interfaces to be recognized as
  // implementing this mixin interface.
  _mixedIntoPredicates: [],
  is(obj) {
    if (obj) {
      if (utils.hasOwn(obj, impl) && obj[impl] instanceof Impl.implementation) {
        return true;
      }
      for (const isMixedInto of module.exports._mixedIntoPredicates) {
        if (isMixedInto(obj)) {
          return true;
        }
      }
    }
    return false;
  },
  isImpl(obj) {
    if (obj) {
      if (obj instanceof Impl.implementation) {
        return true;
      }

      const wrapper = utils.wrapperForImpl(obj);
      for (const isMixedInto of module.exports._mixedIntoPredicates) {
        if (isMixedInto(wrapper)) {
          return true;
        }
      }
    }
    return false;
  },
  convert(obj, { context = "The provided value" } = {}) {
    if (module.exports.is(obj)) {
      return utils.implForWrapper(obj);
    }
    throw new TypeError(`${context} is not of type 'MutationObserver'.`);
  },

  create(constructorArgs, privateData) {
    let obj = Object.create(MutationObserver.prototype);
    obj = this.setup(obj, constructorArgs, privateData);
    return obj;
  },
  createImpl(constructorArgs, privateData) {
    let obj = Object.create(MutationObserver.prototype);
    obj = this.setup(obj, constructorArgs, privateData);
    return utils.implForWrapper(obj);
  },
  _internalSetup(obj) {},
  setup(obj, constructorArgs, privateData) {
    if (!privateData) privateData = {};

    privateData.wrapper = obj;

    this._internalSetup(obj);
    Object.defineProperty(obj, impl, {
      value: new Impl.implementation(constructorArgs, privateData),
      configurable: true
    });

    obj[impl][utils.wrapperSymbol] = obj;
    if (Impl.init) {
      Impl.init(obj[impl], privateData);
    }
    return obj;
  },
  interface: MutationObserver,
  expose: {
    Window: { MutationObserver }
  }
}; // iface
module.exports = iface;

const Impl = require("../mutation-observer/MutationObserver-impl.js");
