import { IGetWaterMarkConfigV2Res } from "../../getWaterMarkConfigV2";
/**
 * 水印页面规则是否生效，1 表示生效，0 表示不生效
 */
export declare enum EnableEnum {
    DISABLE = 0,
    ENABLE = 1
}
export declare enum PageInfoEnum {
    IMSESSIONLIST = "imSessionList",
    DOCPREVIEW = "docPreview",
    H5PAGEOTHER = "h5PageOther",
    MEETINGDETAIL = "meetingDetail",
    H5PAGEBASIC = "h5PageBasic",
    SELECTIONCOMPONENT = "selectionComponent",
    CONTACTLIST = "contactList",
    CONTACTDETAIL = "contactDetail",
    CHAT = "chat",
    SECRETCHAT = "secretChat",
    CAMERA = "camera"
}
export interface IEffectPage {
    imSessionList: EnableEnum;
    docPreview: EnableEnum;
    h5PageOther: EnableEnum;
    meetingDetail: EnableEnum;
    h5PageBasic: EnableEnum;
    selectionComponent: EnableEnum;
    contactList: EnableEnum;
    contactDetail: EnableEnum;
    chat: EnableEnum;
    secretChat: EnableEnum;
    camera: EnableEnum;
}
export interface IWatermarkContent {
    customCopy: string;
    enablePhoneNumber: EnableEnum;
    enableUsername: EnableEnum;
}
/**
 * showDensity number 水印的密度
 * fontStyle number 水印的文本粗细
 * tiltAngle number 水印旋转角度
 * leftAndRightSpacing number 水印左右边距
 * transparency number 水印文本透明度
 * upAndDownSpacing number 水印上下边距
 * fontSize number 水印字体大小
 * fontColor number 水印字体颜色
 */
export interface IWatermarkStyle {
    showDensity: number;
    fontStyle: number;
    tiltAngle: number;
    leftAndRightSpacing: number;
    transparency: number;
    upAndDownSpacing: number;
    fontSize: number;
    fontColor: string;
}
export interface IRuleContent {
    enable: EnableEnum;
    effectPage: IEffectPage;
    watermarkContent: IWatermarkContent;
    watermarkStyle: IWatermarkStyle;
}
export interface IWaterMark {
    ruleContent: IRuleContent;
}
export interface IUserInfo {
    userName: string;
    lastFourPhoneNo: string;
}
export interface IWaterMarkOptions {
    texts: string;
    width: number;
    height: number;
    tiltAngle: number;
    fontColor: string;
    textFont: string;
    transparency: number;
    canvas: HTMLCanvasElement[];
    fontSize: number;
    deg: number;
    tWidth: number;
    tHeight: number;
    fontStyle: fontStyleValuesType;
}
/**
 * normal 正常
 * bold 粗体
 * italic 斜体
 */
declare const fontStyleMap: {
    1: string;
    2: string;
    3: string;
};
/**
 * LOOSE 宽松
 * NORMAL 正常
 * DENSE 密集
 */
declare enum ShowDensityEnum {
    LOOSE = 0,
    NORMAL = 1,
    DENSE = 2
}
export declare type fontStyleMapKeys = keyof typeof fontStyleMap;
export declare type fontStyleValuesType = typeof fontStyleMap[fontStyleMapKeys];
export declare type constructorOptions = Pick<IWaterMarkOptions, 'texts' | 'tiltAngle' | 'fontColor' | 'textFont' | 'fontStyle' | 'transparency' | 'fontSize'> & {
    showDensity: ShowDensityEnum;
    leftAndRightSpacing: number;
    upAndDownSpacing: number;
};
export declare enum HorizontalTypeEnum {
    RIGHT = 0,
    LEFT = 1
}
/**
 *
 * @param {*} conf 配置对象
 * @param {*} pageInfo 仅且在特定配置页面显示水印，默认值 h5PageOther
 */
export default function generateWaterMarkV2(conf: IGetWaterMarkConfigV2Res, pageInfo?: PageInfoEnum): any;
export {};
