/**
 * 用于 JSAPI 鉴权 详见 [JSAPI鉴权](https://openplatform-portal.dg-work.cn/portal/#/helpdoc?docKey=kfzn&slug=qw0y0e)
 *
 * \ **API目录**：业务
 *
 * @apiName JSAPI鉴权
 *
 * @param ticket  string 是  鉴权所需要的ticket，需要从后台获取
 * @param jsApiList string[] 是  需要鉴权的 API 列表
 *
 * @support
 *  - IOS v1.2.0
 *  - Android v1.2.0
 *  - PC v1.2.0
 *
 * @returns
 * res[].name string 校验的JSAPI名称;
 * res[].validateResult boolean false表示鉴权没有通过，true表示鉴权通过
 *
 * @example
 * ```typescript
 *  authConfig({
 *    ticket: 'ticket-abc', // 从后台接口获取ticket
 *     jsApiList: ['chooseContact', 'chooseContactWithComplexPicker'], // 需要鉴权的jsapi列表
 *   })
 *   .then(res => {
 *     console.log(res);
 *     //该数据代表具体jsApi校验结果，校验成功也会有结果
 *     //   [{
 *     //     "name":"chooseContact",
 *     //     "validateResult":false // false表示鉴权没有通过，true表示鉴权通过
 *     //  }]
 *   })
 *   .catch(err => {
 *     console.log(err);
 *   });
 * ```
 */
export interface AuthConfigParams {
    ticket: string;
    jsApiList: string[];
}
export interface ValidateResult {
    name: string;
    validateResult: boolean;
}
declare function authConfig(args: AuthConfigParams): Promise<ValidateResult[]>;
declare namespace authConfig {
    var version: {
        android: string;
        ios: string;
        pc: string;
    };
}
export default authConfig;
