/**
 * 运行容器 mPaaS | DingTalk | Alipay
 */
export declare enum InvokerContainerTypeEnum {
    /**
     * 钉钉容器
     * - 钉钉小程序容器
     * - 钉钉 H5 容器
     * - ...
     */
    DingTalk = "DingTalk",
    /**
     * mPaaS 容器
     */
    mPaaS = "mPaaS",
    /**
     * 支付宝容器
     */
    Alipay = "Alipay",
    Unknown = "unknown"
}
/**
 * 操作系统平台
 */
export declare enum InvokerPlatformTypeEnum {
    Android = "Android",
    IOS = "IOS",
    Mac = "Mac",
    Linux = "Linux",
    Windows = "Windows",
    Unknown = "Unknown"
}
/**
 * 专有钉钉运行脚本的应用类型
 * Mobile | Desktop | MiniApp | WebBrowser | Unknown
 */
export declare enum InvokerAppTypeEnum {
    /**
     * 移动端 Mobile H5
     */
    Mobile = "mobile",
    /**
     * 客户端 Desktop H5
     * Mac / Win / Linux
     */
    Desktop = "desktop",
    /**
     * 小程序 MiniApp
     */
    MiniApp = "mini",
    /**
     * 平台无关，通用 H5
     */
    Web = "web",
    /**
     * 未知平台
     */
    Unknown = "unknown"
}
/**
 * 专有钉钉代码运行时
 * Module：模块
 * Plugin：插件
 * App：正常应用
 */
export declare enum InvokerRuntimeTypeEnum {
    /**
     * 原生本地模块（一般以 app://xxx or file:// 协议在桌面端打开）
     */
    Module = "module",
    /**
     * 模块上的扩展插件
     */
    Plugin = "plugin",
    /**
     * 正常应用
     */
    App = "app",
    Unknown = "Unknown"
}
export declare const UA_IDENTIFIER: string;
export declare function getUAIdentifier(): any;
export declare const getContainerType: () => InvokerContainerTypeEnum;
export declare const APP_NAME: string;
export declare const APP_VERSION: string;
export declare const getPlatformType: () => InvokerPlatformTypeEnum;
/**
 * 获取当前执行应用的类型
 * @public
 * @return InvokerAppTypeEnum
 */
export declare const getAppType: () => InvokerAppTypeEnum;
