package com.artfess.zsj.home.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.zsj.home.vo.SystemWorkOrderHandleVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.zsj.home.model.SystemWorkOrder;
import com.artfess.zsj.home.manager.SystemWorkOrderManager;

import javax.annotation.Resource;

/**
 * 系统工单表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2025-03-12
 */
@RestController
@RequestMapping("/home/systemWorkOrder/v1/")
@Api(tags = "系统工单")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_ZSJ})
public class SystemWorkOrderController extends BaseController<SystemWorkOrderManager, SystemWorkOrder> {

    @Resource
    private SystemWorkOrderManager systemWorkOrderManager;

    @RequestMapping(value = "updateHandlingStatus", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "更新系统工单处理进度", httpMethod = "POST", notes = "更新系统工单处理进度")
    public CommonResult<String> updateHandlingStatus(@ApiParam(name = "model", value = "实体信息") @RequestBody SystemWorkOrderHandleVo t) {
        systemWorkOrderManager.updateHandlingStatus(t);
        return new CommonResult<>(true, "工单进度更新成功");
    }
}
