/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.table.operator.impl.dm;

import com.artfess.table.model.Column;
import com.artfess.table.model.Table;
import com.artfess.table.operator.impl.BaseTableOperator;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.RowMapper;

public class DmTableOperator
extends BaseTableOperator {
    @Override
    public void createTable(Table table) throws SQLException {
        List<Column> columnList = table.getColumnList();
        StringBuffer sb = new StringBuffer();
        String pkColumn = null;
        ArrayList<String> columnCommentList = new ArrayList<String>();
        sb.append("CREATE TABLE " + table.getTableName() + " (\n");
        for (int i = 0; i < columnList.size(); ++i) {
            Column column = columnList.get(i);
            sb.append("    ").append(column.getFieldName()).append("    ");
            sb.append(this.getColumnType(column.getColumnType(), column.getCharLen(), column.getIntLen(), column.getDecimalLen()));
            sb.append(" ");
            if (column.getIsPk()) {
                pkColumn = pkColumn == null ? column.getFieldName() : pkColumn + "," + column.getFieldName();
            }
            if (StringUtils.isNotEmpty((String)column.getDefaultValue())) {
                if ("number".equals(column.getColumnType()) || "int".equals(column.getColumnType())) {
                    sb.append(" DEFAULT " + column.getDefaultValue());
                } else {
                    sb.append(" DEFAULT '" + column.getDefaultValue() + "' ");
                }
            }
            if (column.getComment() != null && column.getComment().length() > 0) {
                String comment = "COMMENT ON COLUMN " + table.getTableName() + "." + column.getFieldName() + " IS '" + column.getComment() + "'\n";
                columnCommentList.add(comment);
            }
            sb.append(",\n");
        }
        if (pkColumn != null) {
            sb.append("    CONSTRAINT PK_").append(table.getTableName()).append(" NOT CLUSTER PRIMARY KEY (").append(pkColumn).append(")");
        }
        sb.append("\n)");
        this.jdbcTemplate.execute(sb.toString());
        if (table.getComment() != null && table.getComment().length() > 0) {
            this.jdbcTemplate.execute("COMMENT ON TABLE " + table.getTableName() + " IS '" + table.getComment() + "'\n");
        }
        for (String columnComment : columnCommentList) {
            this.jdbcTemplate.execute(columnComment);
        }
    }

    @Override
    public String getColumnType(Column column) {
        return this.getColumnType(column.getColumnType(), column.getCharLen(), column.getIntLen(), column.getDecimalLen());
    }

    @Override
    public String getColumnType(String columnType, int charLen, int intLen, int decimalLen) {
        if ("varchar".equals(columnType)) {
            return "VARCHAR2(" + charLen + ')';
        }
        if ("number".equals(columnType)) {
            return "NUMBER(" + (intLen + decimalLen) + "," + decimalLen + ")";
        }
        if ("date".equals(columnType)) {
            return "TIMESTAMP";
        }
        if ("int".equals(columnType)) {
            return "NUMBER(" + intLen + ")";
        }
        if ("clob".equals(columnType)) {
            return "CLOB";
        }
        return "VARCHAR2(200)";
    }

    @Override
    public void dropTable(String tableName) throws SQLException {
        String selSql = "select count(*) amount from user_objects where object_name = upper('" + tableName + "')";
        int rtn = (Integer)this.jdbcTemplate.queryForObject(selSql, Integer.class);
        if (rtn <= 0) {
            return;
        }
        String sql = "drop table " + tableName;
        this.jdbcTemplate.execute(sql);
    }

    @Override
    public void updateTableComment(String tableName, String comment) throws SQLException {
        StringBuffer sb = new StringBuffer();
        sb.append("COMMENT ON TABLE ").append(tableName).append(" IS '").append(comment).append("'\n");
        this.jdbcTemplate.execute(sb.toString());
    }

    @Override
    public void addColumn(String tableName, Column model) throws SQLException {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ").append(tableName);
        sb.append(" ADD ");
        sb.append(model.getFieldName()).append(" ");
        sb.append(this.getColumnType(model.getColumnType(), model.getCharLen(), model.getIntLen(), model.getDecimalLen()));
        if (StringUtils.isNotEmpty((String)model.getDefaultValue())) {
            sb.append(" DEFAULT " + model.getDefaultValue());
        }
        sb.append("\n");
        this.jdbcTemplate.execute(sb.toString());
        if (model.getComment() != null && model.getComment().length() > 0) {
            this.jdbcTemplate.execute("COMMENT ON COLUMN " + tableName + "." + model.getFieldName() + " IS '" + model.getComment() + "'");
        }
    }

    @Override
    public void updateColumn(String tableName, String columnName, Column column) throws SQLException {
        if (!columnName.equals(column.getFieldName())) {
            StringBuffer modifyName = new StringBuffer("ALTER TABLE ").append(tableName);
            modifyName.append(" RENAME COLUMN ").append(columnName).append(" TO ").append(column.getFieldName());
            this.jdbcTemplate.execute(modifyName.toString());
        }
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ").append(tableName);
        sb.append(" MODIFY(" + column.getFieldName()).append(" ");
        sb.append(this.getColumnType(column.getColumnType(), column.getCharLen(), column.getIntLen(), column.getDecimalLen()));
        if (!column.getIsNull()) {
            sb.append(" NOT NULL ");
        }
        sb.append(")");
        this.jdbcTemplate.execute(sb.toString());
        if (column.getComment() != null && column.getComment().length() > 0) {
            this.jdbcTemplate.execute("COMMENT ON COLUMN " + tableName + "." + column.getFieldName() + " IS'" + column.getComment() + "'");
        }
    }

    @Override
    public void addForeignKey(String pkTableName, String fkTableName, String pkField, String fkField) {
        String shortTableName = fkTableName.replaceFirst("(?im)W_", "");
        String sql = " ALTER TABLE " + fkTableName + " ADD CONSTRAINT fk_" + shortTableName + " FOREIGN KEY (" + fkField + ") REFERENCES " + pkTableName + " (" + pkField + ") ON DELETE CASCADE";
        this.jdbcTemplate.execute(sql);
    }

    @Override
    public void dropForeignKey(String tableName, String keyName) {
        String sql = "ALTER   TABLE   " + tableName + "   DROP   CONSTRAINT  " + keyName;
        this.jdbcTemplate.execute(sql);
    }

    @Override
    public List<String> getPKColumns(String tableName) throws SQLException {
        String sql = "SELECT cols.column_name FROM USER_CONSTRAINTS CONS, USER_CONS_COLUMNS COLS WHERE UPPER(cols.table_name) = UPPER('" + tableName + "')" + " AND cons.constraint_type = 'P'" + " AND cons.constraint_name = cols.constraint_name" + " AND CONS.OWNER = COLS.OWNER";
        List columns = this.jdbcTemplate.query(sql, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getString(1);
            }
        });
        return columns;
    }

    @Override
    public Map<String, List<String>> getPKColumns(List<String> tableNames) throws SQLException {
        StringBuffer sb = new StringBuffer();
        for (String name : tableNames) {
            sb.append("'");
            sb.append(name);
            sb.append("',");
        }
        sb.deleteCharAt(sb.length() - 1);
        String sql = "SELECT cols.table_name,cols.column_name FROM USER_CONSTRAINTS CONS, USER_CONS_COLUMNS COLS WHERE UPPER(cols.table_name) in (" + sb.toString().toUpperCase() + ")" + " AND cons.constraint_type = 'P'" + " AND cons.constraint_name = cols.constraint_name" + " AND CONS.OWNER = COLS.OWNER";
        HashMap<String, List<String>> columnsMap = new HashMap<String, List<String>>();
        List maps = this.jdbcTemplate.query(sql, (RowMapper)new RowMapper<Map<String, String>>(){

            public Map<String, String> mapRow(ResultSet rs, int rowNum) throws SQLException {
                String table = rs.getString(1);
                String column = rs.getString(2);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("name", table);
                map.put("column", column);
                return map;
            }
        });
        for (Map map : maps) {
            if (columnsMap.containsKey(map.get("name"))) {
                ((List)columnsMap.get(map.get("name"))).add(map.get("column"));
                continue;
            }
            ArrayList cols = new ArrayList();
            cols.add(map.get("column"));
            columnsMap.put((String)map.get("name"), cols);
        }
        return columnsMap;
    }

    @Override
    public boolean isTableExist(String tableName) {
        StringBuffer sql = new StringBuffer();
        sql.append("select COUNT(1) from user_tables t where t.TABLE_NAME='").append(tableName.toUpperCase()).append("'");
        return (Integer)this.jdbcTemplate.queryForObject(sql.toString(), Integer.class) > 0;
    }

    @Override
    public boolean isExsitPartition(String tableName, String partition) {
        return false;
    }

    @Override
    public void createPartition(String tableName, String partition) {
    }

    @Override
    public boolean supportPartition(String tableName) {
        return false;
    }

    @Override
    public void dropColumn(String tableName, String columnName) throws SQLException {
    }
}

