/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.sysConfig.persistence.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.sysConfig.persistence.dao.SysActuatorDao;
import com.artfess.sysConfig.persistence.manager.SysActuatorManager;
import com.artfess.sysConfig.persistence.model.SysActuator;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class SysActuatorManagerImpl
extends BaseManagerImpl<SysActuatorDao, SysActuator>
implements SysActuatorManager {
    @Resource
    private SysActuatorDao sysActuatorDao;

    @Override
    @Transactional
    public String saveSysActuator(SysActuator sysActuator) {
        Assert.notNull((Object)((Object)sysActuator), (String)"\u4efb\u52a1\u6267\u884c\u5668\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        String msg = "";
        this.checkValidity(sysActuator);
        if (StringUtils.isNotBlank((CharSequence)sysActuator.getId())) {
            this.update((Model)sysActuator);
            msg = "\u66f4\u65b0\u6210\u529f";
        } else {
            sysActuator.setSn(this.getNextSequence(null));
            sysActuator.setFlag(1);
            this.create((Model)sysActuator);
            msg = "\u65b0\u589e\u6210\u529f";
        }
        return msg;
    }

    @Override
    @Transactional
    public String updateSequence(HashMap<String, Object> params) {
        Assert.notNull(params, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        for (String key : params.keySet()) {
            UpdateWrapper updateWrapper = new UpdateWrapper();
            ((UpdateWrapper)updateWrapper.set((Object)"SN_", params.get(key))).eq((Object)"ID_", (Object)key);
            this.update((Wrapper)updateWrapper);
        }
        return "\u6392\u5e8f\u5b8c\u6210";
    }

    @Override
    @Transactional
    public void updateFlag(String ids, Integer flag) {
        List<String> idsList = Arrays.asList(ids.split(","));
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((UpdateWrapper)updateWrapper.set((Object)"FLAG_", (Object)flag)).in((Object)"ID_", idsList);
        this.sysActuatorDao.update(null, (Wrapper)updateWrapper);
    }

    @Override
    @Transactional
    public void deleteBatch(String ids) {
        Assert.hasText((String)ids, (String)"\u53c2\u6570ids\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        List<String> idsList = Arrays.asList(ids.split(","));
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((UpdateWrapper)updateWrapper.set((Object)"IS_DELE_", (Object)"1")).in((Object)"ID_", idsList);
        this.sysActuatorDao.update(null, (Wrapper)updateWrapper);
    }

    @Override
    public List<SysActuator> queryActuator(SysActuator sysActuator) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.like(StringUtils.isNotBlank((CharSequence)sysActuator.getActuatorName()), (Object)"ACTUATOR_NAME_", (Object)sysActuator.getActuatorName());
        queryWrapper.like(StringUtils.isNotBlank((CharSequence)sysActuator.getActuatorIp()), (Object)"ACTUATOR_IP_", (Object)sysActuator.getActuatorIp());
        queryWrapper.eq((Object)"FLAG_", (Object)1);
        queryWrapper.eq((Object)"IS_DELE_", (Object)1);
        queryWrapper.orderByAsc((Object)"SN_");
        return this.sysActuatorDao.selectList((Wrapper)queryWrapper);
    }

    private void checkValidity(SysActuator sysActuator) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.ne(StringUtils.isNotBlank((CharSequence)sysActuator.getId()), (Object)"ID_", (Object)sysActuator.getId());
        ((QueryWrapper)queryWrapper.nested(qw -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)qw.eq((Object)"ACTUATOR_NAME_", (Object)sysActuator.getActuatorName())).or()).eq((Object)"EXECUTION_PATH_", (Object)sysActuator.getExecutionPath());
        })).eq((Object)"IS_DELE_", (Object)"0");
        Integer count = this.sysActuatorDao.selectCount((Wrapper)queryWrapper);
        if (count > 0) {
            throw new ApplicationException("\u540d\u79f0\u6216\u6267\u884c\u8def\u5f84\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u5c1d\u8bd5\uff01");
        }
    }
}

