/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.sysConfig.persistence.manager.impl;

import com.artfess.base.cache.annotation.CacheEvict;
import com.artfess.base.exception.ServerRejectException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.sysConfig.persistence.dao.SysRoleAuthDao;
import com.artfess.sysConfig.persistence.manager.SysRoleAuthManager;
import com.artfess.sysConfig.persistence.model.SysRoleAuth;
import com.artfess.sysConfig.persistence.param.SysRoleAuthParam;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="sysRoleAuthManager")
public class SysRoleAuthManagerImpl
extends BaseManagerImpl<SysRoleAuthDao, SysRoleAuth>
implements SysRoleAuthManager {
    @Value(value="${system.mode.demo:false}")
    protected boolean demoMode;

    private void removeMethodRoleAuth() {
        SysRoleAuthManagerImpl bean = (SysRoleAuthManagerImpl)AppUtil.getBean(this.getClass());
        bean.delMethodRoleAuth();
    }

    @CacheEvict(value={"bpm:sys:methodAuth"}, allEntries=true)
    protected void delMethodRoleAuth() {
    }

    private void removeUserMenu() {
        SysRoleAuthManagerImpl bean = (SysRoleAuthManagerImpl)AppUtil.getBean(this.getClass());
        bean.delUserMenu();
    }

    @CacheEvict(value={"bpm:sys:userMenu:new"}, allEntries=true)
    protected void delUserMenu() {
    }

    private void removeDataPermission() {
        SysRoleAuthManagerImpl bean = (SysRoleAuthManagerImpl)AppUtil.getBean(this.getClass());
        bean.delDataPermission();
    }

    @CacheEvict(value={"bpm:sys:dataPermission"}, allEntries=true)
    protected void delDataPermission() {
    }

    @Override
    public List<SysRoleAuth> getSysRoleAuthByRoleAlias(String roleAlias) {
        return ((SysRoleAuthDao)this.baseMapper).getSysRoleAuthByRoleAlias(roleAlias);
    }

    @Override
    public List<String> getMenuAliasByRoleAlias(String roleAlias) {
        return ((SysRoleAuthDao)this.baseMapper).getMenuAliasByRoleAlias(roleAlias);
    }

    @Override
    public List<String> getMethodAliasByRoleAlias(String roleAlias) {
        return ((SysRoleAuthDao)this.baseMapper).getMethodAliasByRoleAlias(roleAlias);
    }

    @Override
    public void removeByRoleAlias(String roleAlias) {
        ((SysRoleAuthDao)this.baseMapper).removeByRoleAlias(roleAlias);
    }

    @Override
    public void removeByArrRoleAlias(String[] aryroleAlias) {
        for (String roleAlias : aryroleAlias) {
            ((SysRoleAuthDao)this.baseMapper).removeByRoleAlias(roleAlias);
        }
        this.removeMethodRoleAuth();
        this.removeUserMenu();
        this.removeDataPermission();
    }

    @Override
    public void create(SysRoleAuthParam sysRoleAuthParam) {
        if (this.demoMode) {
            throw new ServerRejectException("\u6f14\u793a\u6a21\u5f0f\u4e0b\u65e0\u6cd5\u6267\u884c\u8be5\u64cd\u4f5c");
        }
        ((SysRoleAuthDao)this.baseMapper).removeByRoleAlias(sysRoleAuthParam.getRoleAlias());
        List<String> arrMenuAlias = sysRoleAuthParam.getArrMenuAlias();
        SysRoleAuth sysRoleAuth = new SysRoleAuth();
        sysRoleAuth.setRoleAlias(sysRoleAuthParam.getRoleAlias());
        for (String menuAlias : arrMenuAlias) {
            sysRoleAuth.setId(UniqueIdUtil.getSuid());
            sysRoleAuth.setMenuAlias(menuAlias);
            ((SysRoleAuthDao)this.baseMapper).insert((Object)sysRoleAuth);
        }
        sysRoleAuth.setMenuAlias(null);
        List<String> arrMethodAlias = sysRoleAuthParam.getArrMethodAlias();
        Map<String, String> dataPermission = sysRoleAuthParam.getDataPermission();
        for (String methodAlias : arrMethodAlias) {
            sysRoleAuth.setId(UniqueIdUtil.getSuid());
            sysRoleAuth.setMethodAlias(methodAlias);
            sysRoleAuth.setDataPermission(dataPermission.get(methodAlias));
            ((SysRoleAuthDao)this.baseMapper).insert((Object)sysRoleAuth);
        }
        this.removeMethodRoleAuth();
        this.removeUserMenu();
        this.removeDataPermission();
    }

    @Override
    public List<HashMap<String, String>> getSysRoleAuthAll() {
        ArrayList<HashMap<String, String>> result = new ArrayList<HashMap<String, String>>();
        ArrayList sysRoleAuths = (ArrayList)((SysRoleAuthDao)this.baseMapper).getSysRoleAuthAll();
        for (SysRoleAuth sysRoleAuth : sysRoleAuths) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("roleAlias", sysRoleAuth.getRoleAlias());
            map.put("methodRequestUrl", sysRoleAuth.getMethodRequestUrl());
            map.put("dataPermission", sysRoleAuth.getDataPermission());
            result.add(map);
        }
        return result;
    }

    @Override
    public void createCopy(String oldCode, String[] newCodes) {
        for (int i = 0; i < newCodes.length; ++i) {
            ((SysRoleAuthDao)this.baseMapper).removeByRoleAlias(newCodes[i]);
        }
        List<String> strList = this.getMenuAliasByRoleAlias(oldCode);
        for (int i = 0; i < newCodes.length; ++i) {
            for (String menuAlias : strList) {
                SysRoleAuth sysRoleAuth = new SysRoleAuth();
                sysRoleAuth.setId(UniqueIdUtil.getSuid());
                sysRoleAuth.setRoleAlias(newCodes[i]);
                sysRoleAuth.setMenuAlias(menuAlias);
                ((SysRoleAuthDao)this.baseMapper).insert((Object)sysRoleAuth);
            }
        }
        this.removeMethodRoleAuth();
        this.removeUserMenu();
    }

    @Override
    public void saveRoleMethods(SysRoleAuthParam sysRoleAuthParam) {
        if (this.demoMode) {
            throw new ServerRejectException("\u6f14\u793a\u6a21\u5f0f\u4e0b\u65e0\u6cd5\u6267\u884c\u8be5\u64cd\u4f5c");
        }
        SysRoleAuth sysRoleAuth = new SysRoleAuth();
        sysRoleAuth.setRoleAlias(sysRoleAuthParam.getRoleAlias());
        List<String> methodAliasByRoleAlias = this.getMethodAliasByRoleAlias(sysRoleAuth.getRoleAlias());
        List<String> arrMethodAlias = sysRoleAuthParam.getArrMethodAlias();
        Map<String, String> dataPermission = sysRoleAuthParam.getDataPermission();
        for (String methodAlias : arrMethodAlias) {
            sysRoleAuth.setId(UniqueIdUtil.getSuid());
            sysRoleAuth.setMethodAlias(methodAlias);
            sysRoleAuth.setDataPermission(dataPermission.get(methodAlias));
            if (methodAliasByRoleAlias.contains(methodAlias)) continue;
            this.create((Model)sysRoleAuth);
        }
        this.removeMethodRoleAuth();
        this.removeDataPermission();
    }

    @Override
    public void removeRoleMethods(String roleAlias, String[] methodAliasArr) {
        ((SysRoleAuthDao)this.baseMapper).removeRoleMethods(roleAlias, methodAliasArr);
        this.removeMethodRoleAuth();
        this.removeDataPermission();
    }
}

