/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.xsom.impl;

import com.sun.xml.xsom.SCD;
import com.sun.xml.xsom.XSAnnotation;
import com.sun.xml.xsom.XSComponent;
import com.sun.xml.xsom.XSSchemaSet;
import com.sun.xml.xsom.impl.AnnotationImpl;
import com.sun.xml.xsom.impl.ForeignAttributesImpl;
import com.sun.xml.xsom.impl.SchemaImpl;
import com.sun.xml.xsom.impl.parser.SchemaDocumentImpl;
import com.sun.xml.xsom.parser.SchemaDocument;
import com.sun.xml.xsom.util.ComponentNameFunction;
import com.sun.xml.xsom.visitor.XSFunction;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import org.xml.sax.Locator;

public abstract class ComponentImpl
implements XSComponent {
    protected final SchemaDocumentImpl ownerDocument;
    private AnnotationImpl annotation;
    private final Locator locator;
    private Object foreignAttributes;

    protected ComponentImpl(SchemaDocumentImpl _owner, AnnotationImpl _annon, Locator _loc, ForeignAttributesImpl fa) {
        this.ownerDocument = _owner;
        this.annotation = _annon;
        this.locator = _loc;
        this.foreignAttributes = fa;
    }

    public SchemaImpl getOwnerSchema() {
        if (this.ownerDocument == null) {
            return null;
        }
        return this.ownerDocument.getSchema();
    }

    public XSSchemaSet getRoot() {
        if (this.ownerDocument == null) {
            return null;
        }
        return this.getOwnerSchema().getRoot();
    }

    public SchemaDocument getSourceDocument() {
        return this.ownerDocument;
    }

    public final XSAnnotation getAnnotation() {
        return this.annotation;
    }

    public XSAnnotation getAnnotation(boolean createIfNotExist) {
        if (createIfNotExist && this.annotation == null) {
            this.annotation = new AnnotationImpl();
        }
        return this.annotation;
    }

    public final Locator getLocator() {
        return this.locator;
    }

    public List<ForeignAttributesImpl> getForeignAttributes() {
        List<ForeignAttributesImpl> t = this.foreignAttributes;
        if (t == null) {
            return Collections.EMPTY_LIST;
        }
        if (t instanceof List) {
            return t;
        }
        t = this.foreignAttributes = this.convertToList((ForeignAttributesImpl)t);
        return t;
    }

    public String getForeignAttribute(String nsUri, String localName) {
        List<ForeignAttributesImpl> attrs = this.getForeignAttributes();
        if (attrs == null) {
            return null;
        }
        for (ForeignAttributesImpl fa : attrs) {
            String v = fa.getValue(nsUri, localName);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    private List<ForeignAttributesImpl> convertToList(ForeignAttributesImpl fa) {
        ArrayList<ForeignAttributesImpl> lst = new ArrayList<ForeignAttributesImpl>();
        while (fa != null) {
            lst.add(fa);
            fa = fa.next;
        }
        return Collections.unmodifiableList(lst);
    }

    public Collection<XSComponent> select(String scd, NamespaceContext nsContext) {
        try {
            return SCD.create((String)scd, (NamespaceContext)nsContext).select((XSComponent)this);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public XSComponent selectSingle(String scd, NamespaceContext nsContext) {
        try {
            return SCD.create((String)scd, (NamespaceContext)nsContext).selectSingle((XSComponent)this);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String toString() {
        return (String)this.apply((XSFunction)new ComponentNameFunction());
    }
}

