/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.es.unit;

import com.artfess.base.util.JsonUtil;
import com.artfess.es.unit.ElasticSearchApplication;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.core.CountRequest;
import org.elasticsearch.client.core.CountResponse;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.index.reindex.UpdateByQueryRequest;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.ScoreSortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.search.suggest.Suggest;
import org.elasticsearch.search.suggest.SuggestBuilder;
import org.elasticsearch.search.suggest.SuggestBuilders;
import org.elasticsearch.search.suggest.SuggestionBuilder;
import org.elasticsearch.search.suggest.completion.CompletionSuggestion;
import org.elasticsearch.search.suggest.completion.CompletionSuggestionBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ElasticSearchApplicationImpl
implements ElasticSearchApplication {
    private static final Logger log = LoggerFactory.getLogger(ElasticSearchApplicationImpl.class);
    private final RestHighLevelClient restHighLevelClient;

    @Autowired
    public ElasticSearchApplicationImpl(RestHighLevelClient restHighLevelClient) {
        this.restHighLevelClient = restHighLevelClient;
    }

    @Override
    public boolean existsIndex(String indexName, String id) {
        if (StringUtils.isEmpty((Object)indexName) || StringUtils.isEmpty((Object)id)) {
            return false;
        }
        GetRequest getRequest = new GetRequest(indexName, id);
        try {
            return this.restHighLevelClient.exists(getRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            log.error("\u68c0\u67e5id\uff1a{}\u662f\u5426\u5b58\u5728\u4e8eindexName:{}\u51fa\u73b0\u5f02\u5e38", new Object[]{id, indexName, e});
            return false;
        }
    }

    @Override
    public <T> boolean insertDocument(String indexName, String id, T t) {
        IndexRequest indexRequest = new IndexRequest(indexName);
        if (!StringUtils.isEmpty((Object)id)) {
            indexRequest.id(id);
        }
        indexRequest.source(JsonUtil.toJsonString(t), XContentType.JSON);
        try {
            this.restHighLevelClient.index(indexRequest, RequestOptions.DEFAULT);
            return true;
        }
        catch (IOException e) {
            log.error("\u7d22\u5f15\u6570\u636e\u81f3[{}]\u5931\u8d25\uff0c\u5bf9\u8c61\u81f3\uff1a{}", new Object[]{indexName, JsonUtil.toJsonString(t), e});
            return false;
        }
    }

    @Override
    public <T> boolean insertDocument(String indexName, List<T> list) throws IOException {
        BulkRequest bulkRequest = new BulkRequest();
        for (T item : list) {
            ObjectMapper mapper = JsonUtil.getMapper();
            JsonNode json = JsonUtil.toJsonNode(item);
            String s = mapper.writeValueAsString(item);
            String id = json.get("id").asText();
            if (StringUtils.isEmpty((Object)id)) {
                bulkRequest.add(new IndexRequest(indexName).source(new Object[]{json, XContentType.JSON}));
                continue;
            }
            bulkRequest.add(new IndexRequest(indexName).id(id).source(new Object[]{json, XContentType.JSON}));
        }
        try {
            this.restHighLevelClient.bulk(bulkRequest, RequestOptions.DEFAULT);
            return true;
        }
        catch (IOException e) {
            log.error("\u6279\u91cf\u7d22\u5f15\u6570\u636e\u81f3[{}]\u5931\u8d25", (Object)indexName, (Object)e);
            return false;
        }
    }

    @Override
    public <T> boolean insertDocument(String indexName, String pipeLine, List<T> list) throws IOException {
        BulkRequest bulkRequest = new BulkRequest();
        for (T item : list) {
            ObjectMapper mapper = JsonUtil.getMapper();
            JsonNode json = JsonUtil.toJsonNode(item);
            String s = mapper.writeValueAsString(item);
            String id = json.get("id").asText();
            if (StringUtils.isEmpty((Object)id)) {
                bulkRequest.add(new IndexRequest(indexName).setPipeline(pipeLine).source(new Object[]{json, XContentType.JSON}));
                continue;
            }
            bulkRequest.add(new IndexRequest(indexName).id(id).setPipeline(pipeLine).source(new Object[]{json, XContentType.JSON}));
        }
        try {
            this.restHighLevelClient.bulk(bulkRequest, RequestOptions.DEFAULT);
            return true;
        }
        catch (IOException e) {
            log.error("\u6279\u91cf\u7d22\u5f15\u6570\u636e\u81f3[{}]\u5931\u8d25", (Object)indexName, (Object)e);
            return false;
        }
    }

    @Override
    public void updateById(String indexName, String id, Map<String, Object> map) {
        UpdateRequest updateRequest = new UpdateRequest(indexName, id);
        updateRequest.doc(map);
        try {
            this.restHighLevelClient.update(updateRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            log.error("\u6570\u636e\u4fee\u6539\u51fa\u73b0\u5f02\u5e38\uff0cid\uff1a{}", (Object)id, (Object)e);
        }
    }

    @Override
    public void updateById(String indexName, List<String> ids, Map<String, Object> map) {
        BulkRequest bulkRequest = new BulkRequest();
        for (String id : ids) {
            bulkRequest.add(new UpdateRequest(indexName, id).doc(map));
        }
        try {
            this.restHighLevelClient.bulk(bulkRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            log.error("\u6570\u636e\u6279\u91cf\u4fee\u6539\u51fa\u73b0\u5f02\u5e38\uff01");
        }
    }

    @Override
    public Long updateByQueryBuilder(String indexName, QueryBuilder queryBuilder, Map<String, Object> map) {
        UpdateByQueryRequest updateByQueryRequest = new UpdateByQueryRequest(new String[]{indexName});
        updateByQueryRequest.setQuery(queryBuilder);
        if (map.isEmpty()) {
            return 0L;
        }
        SimpleDateFormat sm = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Iterator<String> iterator = map.keySet().iterator();
        StringBuilder str = new StringBuilder();
        while (iterator.hasNext()) {
            String key = iterator.next();
            Object value = map.get(key);
            if (value != null && value instanceof Date) {
                str.append(";ctx._source." + key + "='" + sm.format(map.get(key)) + "'");
                continue;
            }
            str.append(";ctx._source." + key + "='" + map.get(key) + "'");
        }
        updateByQueryRequest.setScript(new Script(str.substring(1)));
        try {
            BulkByScrollResponse re = this.restHighLevelClient.updateByQuery(updateByQueryRequest, RequestOptions.DEFAULT);
            return re.getDeleted();
        }
        catch (IOException e) {
            log.error("\u6570\u636e\u5220\u9664\u51fa\u73b0\u5f02\u5e38!");
            return 0L;
        }
    }

    @Override
    public void updateByQueryBuilderOfAsync(String indexName, QueryBuilder queryBuilder, Map<String, Object> map, ActionListener<BulkByScrollResponse> actionListener) {
        UpdateByQueryRequest updateByQueryRequest = new UpdateByQueryRequest(new String[]{indexName});
        updateByQueryRequest.setQuery(queryBuilder);
        if (map.isEmpty()) {
            return;
        }
        SimpleDateFormat sm = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Iterator<String> iterator = map.keySet().iterator();
        StringBuilder str = new StringBuilder();
        while (iterator.hasNext()) {
            String key = iterator.next();
            Object value = map.get(key);
            if (value != null && value instanceof Date) {
                str.append(";ctx._source." + key + "='" + sm.format(map.get(key)) + "'");
                continue;
            }
            str.append(";ctx._source." + key + "='" + map.get(key) + "'");
        }
        updateByQueryRequest.setScript(new Script(str.substring(1)));
        this.restHighLevelClient.updateByQueryAsync(updateByQueryRequest, RequestOptions.DEFAULT, actionListener);
    }

    @Override
    public void delById(String indexName, String id) {
        DeleteRequest deleteRequest = new DeleteRequest(indexName, id);
        try {
            this.restHighLevelClient.delete(deleteRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            log.error("\u6570\u636e\u5220\u9664\u51fa\u73b0\u5f02\u5e38\uff0cid\uff1a{}", (Object)id, (Object)e);
        }
    }

    @Override
    public void delByIds(String indexName, List<String> ids) {
        BulkRequest bulkRequest = new BulkRequest();
        for (String id : ids) {
            bulkRequest.add(new DeleteRequest(indexName, id));
        }
        try {
            this.restHighLevelClient.bulk(bulkRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            log.error("\u6570\u636e\u6279\u91cf\u5220\u9664\u51fa\u73b0\u5f02\u5e38\uff0cid\uff1a{}", (Object)String.join((CharSequence)",", ids), (Object)e);
        }
    }

    @Override
    public Long delByQuery(String indexName, QueryBuilder queryBuilder) {
        DeleteByQueryRequest deleteByQueryRequest = new DeleteByQueryRequest(new String[]{indexName});
        deleteByQueryRequest.setQuery(queryBuilder);
        deleteByQueryRequest.setConflicts("proceed");
        try {
            BulkByScrollResponse bulkByScrollResponse = this.restHighLevelClient.deleteByQuery(deleteByQueryRequest, RequestOptions.DEFAULT);
            return bulkByScrollResponse.getDeleted();
        }
        catch (IOException e) {
            log.error("\u6570\u636e\u6279\u91cf\u5220\u9664\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
            return 0L;
        }
    }

    @Override
    public <T> T queryById(String indexName, String id, Class<T> c) {
        GetRequest getRequest = new GetRequest(indexName, id);
        try {
            GetResponse getResponse = this.restHighLevelClient.get(getRequest, RequestOptions.DEFAULT);
            if (getResponse.isSourceEmpty()) {
                return null;
            }
            getResponse.getSourceAsMap().put("id", id);
            return (T)JsonUtil.getMapper().readValue(getResponse.getSourceAsString(), c);
        }
        catch (IOException e) {
            log.error("\u6570\u636e\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38\uff0cid\uff1a{}", (Object)id, (Object)e);
            return null;
        }
    }

    @Override
    public GetResponse queryGetResponseById(String indexName, String id) {
        GetRequest getRequest = new GetRequest(indexName, id);
        try {
            return this.restHighLevelClient.get(getRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            log.error("\u6570\u636e\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38\uff0cid\uff1a{}", (Object)id, (Object)e);
            return null;
        }
    }

    @Override
    public Map<String, Object> queryMapById(String indexName, String id) {
        GetRequest getRequest = new GetRequest(indexName, id);
        try {
            GetResponse getResponse = this.restHighLevelClient.get(getRequest, RequestOptions.DEFAULT);
            getResponse.getSourceAsMap().put("id", id);
            return getResponse.getSourceAsMap();
        }
        catch (IOException e) {
            log.error("\u6570\u636e\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38\uff0cid\uff1a{}", (Object)id, (Object)e);
            return null;
        }
    }

    @Override
    public List<Map<String, Object>> queryDataByQueryBuilder(String indexName, QueryBuilder queryBuilder) {
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.timeout(new TimeValue(60L, TimeUnit.SECONDS));
        searchRequest.source(searchSourceBuilder.query(queryBuilder));
        try {
            SearchResponse searchResponse = this.restHighLevelClient.search(searchRequest, RequestOptions.DEFAULT);
            SearchHit[] hits = searchResponse.getHits().getHits();
            if (hits.length == 0) {
                return null;
            }
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            for (SearchHit hit : hits) {
                list.add(hit.getSourceAsMap());
            }
            return list;
        }
        catch (IOException e) {
            log.error("\u6570\u636e\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38!");
            return null;
        }
    }

    @Override
    public List<Map<String, Object>> queryDataByQueryBuilder(String indexName, BoolQueryBuilder queryBuilder, SortOrder sortOrder, List<String> filedName) {
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.timeout(new TimeValue(60L, TimeUnit.SECONDS));
        searchRequest.source(searchSourceBuilder.query((QueryBuilder)queryBuilder));
        if (filedName != null) {
            for (String fieldName : filedName) {
                searchSourceBuilder.sort(new FieldSortBuilder(fieldName).order(sortOrder));
            }
        }
        try {
            SearchResponse searchResponse = this.restHighLevelClient.search(searchRequest, RequestOptions.DEFAULT);
            SearchHit[] hits = searchResponse.getHits().getHits();
            if (hits.length == 0) {
                return null;
            }
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            for (SearchHit hit : hits) {
                list.add(hit.getSourceAsMap());
            }
            return list;
        }
        catch (IOException e) {
            log.error("\u6570\u636e\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38!");
            return null;
        }
    }

    @Override
    public Map<String, Object> queryDataByQueryBuilder(String indexName, QueryBuilder queryBuilder, Integer pageNum, Integer pageSize) {
        if ((pageNum = Integer.valueOf(pageNum - 1)) <= 0) {
            pageNum = 0;
        }
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.from(pageNum * pageSize);
        searchSourceBuilder.size(pageSize.intValue());
        searchSourceBuilder.timeout(new TimeValue(60L, TimeUnit.SECONDS));
        searchRequest.source(searchSourceBuilder.query(queryBuilder));
        try {
            SearchResponse searchResponse = this.restHighLevelClient.search(searchRequest, RequestOptions.DEFAULT);
            SearchHit[] hits = searchResponse.getHits().getHits();
            HashMap<String, Object> map = new HashMap<String, Object>();
            long total = searchResponse.getHits().getTotalHits().value;
            long pages = total % (long)pageSize.intValue() == 0L ? total / (long)pageSize.intValue() : total / (long)pageSize.intValue() + 1L;
            ArrayList<Map> list = new ArrayList<Map>();
            for (SearchHit hit : hits) {
                Map sourceAsMap = hit.getSourceAsMap();
                sourceAsMap.put("id", hit.getId());
                list.add(sourceAsMap);
            }
            map.put("current", pageNum + 1);
            map.put("size", pageSize);
            map.put("pages", pages);
            map.put("records", list);
            map.put("total", total);
            return map;
        }
        catch (IOException e) {
            log.error("\u6570\u636e\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38!");
            return null;
        }
    }

    @Override
    public Map<String, Object> queryDataByQueryBuilder(String indexName, QueryBuilder queryBuilder, String name, SortOrder order, Integer pageNum, Integer pageSize) {
        if ((pageNum = Integer.valueOf(pageNum - 1)) <= 0) {
            pageNum = 0;
        }
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.from(pageNum * pageSize);
        searchSourceBuilder.size(pageSize.intValue());
        searchSourceBuilder.sort(name, order);
        searchSourceBuilder.timeout(new TimeValue(60L, TimeUnit.SECONDS));
        searchRequest.source(searchSourceBuilder.query(queryBuilder));
        try {
            SearchResponse searchResponse = this.restHighLevelClient.search(searchRequest, RequestOptions.DEFAULT);
            SearchHit[] hits = searchResponse.getHits().getHits();
            HashMap<String, Object> map = new HashMap<String, Object>();
            long total = searchResponse.getHits().getTotalHits().value;
            long pages = total % (long)pageSize.intValue() == 0L ? total / (long)pageSize.intValue() : total / (long)pageSize.intValue() + 1L;
            ArrayList<Map> list = new ArrayList<Map>();
            for (SearchHit hit : hits) {
                Map sourceAsMap = hit.getSourceAsMap();
                sourceAsMap.put("id", hit.getId());
                list.add(sourceAsMap);
            }
            map.put("current", pageNum + 1);
            map.put("size", pageSize);
            map.put("pages", pages);
            map.put("records", list);
            map.put("total", total);
            return map;
        }
        catch (IOException e) {
            log.error("\u6570\u636e\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38!");
            e.printStackTrace();
            return null;
        }
    }

    public Map<String, Map<String, Long>> getTermsAggTwoLevel(QueryBuilder queryBuilder, String field1, String field2, String index) throws IOException {
        HashMap<String, Map<String, Long>> groupMap = new HashMap<String, Map<String, Long>>();
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query(queryBuilder);
        searchSourceBuilder.size(0);
        ValuesSourceAggregationBuilder agg1 = AggregationBuilders.terms((String)"agg1").field(field1);
        ValuesSourceAggregationBuilder agg2 = AggregationBuilders.terms((String)"agg2").field(field2);
        agg1.subAggregation((AggregationBuilder)agg2);
        searchSourceBuilder.aggregation((AggregationBuilder)agg1);
        SearchRequest searchRequest = new SearchRequest(new String[]{index});
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = this.restHighLevelClient.search(searchRequest, RequestOptions.DEFAULT);
        Terms terms1 = (Terms)searchResponse.getAggregations().get("agg1");
        for (Terms.Bucket bucket1 : terms1.getBuckets()) {
            Terms terms2 = (Terms)bucket1.getAggregations().get("agg2");
            HashMap<String, Long> map2 = new HashMap<String, Long>();
            for (Terms.Bucket bucket2 : terms2.getBuckets()) {
                map2.put(bucket2.getKey().toString(), bucket2.getDocCount());
            }
            groupMap.put(bucket1.getKey().toString(), map2);
        }
        return groupMap;
    }

    @Override
    public Map<String, Object> queryForFullText(String indexName, SearchSourceBuilder searchSourceBuilder, int pageNum, int pageSize, List<String> fieldNameForSort, SortOrder sortOrder, String[] heightFields) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<Map> list = new ArrayList<Map>();
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        if (searchSourceBuilder == null) {
            searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.query((QueryBuilder)QueryBuilders.matchAllQuery());
        }
        if (pageSize != 0) {
            searchSourceBuilder.from(pageNum * pageSize);
            searchSourceBuilder.size(pageSize);
        }
        searchSourceBuilder.sort(new ScoreSortBuilder().order(SortOrder.DESC));
        if (fieldNameForSort != null) {
            for (String fieldName : fieldNameForSort) {
                searchSourceBuilder.sort(new FieldSortBuilder(fieldName).order(sortOrder));
            }
        }
        boolean flag = false;
        if (heightFields != null && heightFields.length != 0) {
            flag = true;
            HighlightBuilder highlightBuilder = new HighlightBuilder();
            for (String str : heightFields) {
                if (StringUtils.isEmpty((Object)str)) continue;
                highlightBuilder.boundaryMaxScan(Integer.valueOf(50));
                highlightBuilder.field(str, 400).numOfFragments(Integer.valueOf(1));
            }
            highlightBuilder.preTags(new String[]{"<em style=\"color:red\">"});
            highlightBuilder.postTags(new String[]{"</em>"});
            searchSourceBuilder.highlighter(highlightBuilder);
        }
        searchRequest.source(searchSourceBuilder);
        try {
            SearchResponse searchResponse = this.restHighLevelClient.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = searchResponse.getHits();
            for (SearchHit hit : hits.getHits()) {
                Map mapTmep = hit.getSourceAsMap();
                mapTmep.put("id", hit.getId());
                mapTmep.put("score", Float.valueOf(hit.getScore()));
                if (flag) {
                    Map highlightFields = hit.getHighlightFields();
                    for (String str : heightFields) {
                        if (!highlightFields.containsKey(str)) continue;
                        HighlightField highlight = (HighlightField)highlightFields.get(str);
                        Text[] fragments = highlight.fragments();
                        StringBuilder fragmentString = new StringBuilder();
                        for (Text text : fragments) {
                            fragmentString.append(text.toString() + "</br>");
                        }
                        mapTmep.put(str, fragmentString.toString());
                    }
                }
                list.add(mapTmep);
            }
            long total = searchResponse.getHits().getTotalHits().value;
            long pages = total % (long)pageSize == 0L ? total / (long)pageSize : total / (long)pageSize + 1L;
            map.put("current", pageNum + 1);
            map.put("size", pageSize);
            map.put("pages", pages);
            map.put("records", list);
            map.put("total", total);
            map.put("tookTime", searchResponse.getTook().getMillis());
        }
        catch (IOException e) {
            log.error("\u6570\u636e\u68c0\u7d22\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return null;
        }
        return map;
    }

    @Override
    public SearchResponse queryForAggregation(String indexName, QueryBuilder queryBuilder, AggregationBuilder aggregationBuilder) throws IOException {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query(queryBuilder);
        searchSourceBuilder.aggregation(aggregationBuilder);
        searchSourceBuilder.size(0);
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = this.restHighLevelClient.search(searchRequest, RequestOptions.DEFAULT);
        return searchResponse;
    }

    @Override
    public Long countByQueryBuilder(String indexName, QueryBuilder queryBuilder) {
        CountRequest countRequest = new CountRequest(new String[]{indexName});
        countRequest.query(queryBuilder);
        try {
            CountResponse countResponse = this.restHighLevelClient.count(countRequest, RequestOptions.DEFAULT);
            return countResponse.getCount();
        }
        catch (IOException e) {
            log.error("\u6570\u636e\u7edf\u8ba1\u9519\u8bef\uff01");
            return null;
        }
    }

    @Override
    public List<String> searchCompletionSuggest(String idxName, SearchSourceBuilder builder) {
        SearchRequest request = new SearchRequest(new String[]{idxName});
        request.source(builder);
        try {
            SearchResponse response = this.restHighLevelClient.search(request, RequestOptions.DEFAULT);
            List<String> list = StreamSupport.stream(Spliterators.spliteratorUnknownSize(response.getSuggest().iterator(), 16), false).flatMap(suggestion -> ((Suggest.Suggestion.Entry)suggestion.getEntries().get(0)).getOptions().stream()).map(option -> option.getText().toString()).collect(Collectors.toList());
            return list;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> getSuggestSearch(String keyword, String indexName) {
        CompletionSuggestionBuilder suggestionBuilderDistrict = (CompletionSuggestionBuilder)SuggestBuilders.completionSuggestion((String)"\u914d\u7f6e\u4e86type=completion\u7684\u5b57\u6bb5\u540d").prefix(keyword).size(3);
        SuggestBuilder suggestBuilder = new SuggestBuilder();
        suggestBuilder.addSuggestion("suggestDistrict", (SuggestionBuilder)suggestionBuilderDistrict);
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        Object requestBuilder = null;
        SearchResponse response = (SearchResponse)requestBuilder.get();
        Suggest suggest = response.getSuggest();
        HashSet<String> suggestSet = new HashSet<String>();
        int maxSuggest = 0;
        if (suggest != null) {
            Suggest.Suggestion result = suggest.getSuggestion("suggestDistrict");
            for (Object term : result.getEntries()) {
                CompletionSuggestion.Entry item;
                if (term instanceof CompletionSuggestion.Entry && !(item = (CompletionSuggestion.Entry)term).getOptions().isEmpty()) {
                    for (CompletionSuggestion.Entry.Option option : item.getOptions()) {
                        String tip = option.getText().toString();
                        if (suggestSet.contains(tip)) continue;
                        suggestSet.add(tip);
                        ++maxSuggest;
                    }
                }
                if (maxSuggest < 5) continue;
                break;
            }
        }
        List<String> suggests = Arrays.asList(suggestSet.toArray(new String[0]));
        return suggests;
    }
}

