/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.persistence.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.bpm.persistence.dao.BpmDefUserDao;
import com.artfess.bpm.persistence.manager.BpmDefUserManager;
import com.artfess.bpm.persistence.manager.CurrentUserService;
import com.artfess.bpm.persistence.model.BpmDefUser;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BpmDefUserManagerImpl
extends BaseManagerImpl<BpmDefUserDao, BpmDefUser>
implements BpmDefUserManager {
    @Resource(name="bpmCurrentUserService")
    private CurrentUserService currentUserService;

    @Override
    public ArrayNode getRights(String authorizeId, String objType) throws IOException {
        String ownerNameJson = "[]";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("authorizeId", authorizeId);
        params.put("objType", objType);
        List<BpmDefUser> bpmDefUsers = ((BpmDefUserDao)this.baseMapper).getAll(params);
        ownerNameJson = this.toOwnerNameJson(bpmDefUsers);
        return (ArrayNode)JsonUtil.toJsonNode((String)ownerNameJson);
    }

    @Override
    @Transactional
    public void saveRights(String authorizeId, String objType, String ownerNameJson) throws IOException {
        if (StringUtil.isNotEmpty((String)ownerNameJson)) {
            ((BpmDefUserDao)this.baseMapper).delByAuthorizeId(authorizeId, objType);
            List<BpmDefUser> bpmDefUserList = this.toBpmDefUserList(ownerNameJson, authorizeId);
            for (BpmDefUser bpmDefUser : bpmDefUserList) {
                bpmDefUser.setObjType(objType);
                super.create((Model)bpmDefUser);
            }
        }
    }

    private List<BpmDefUser> toBpmDefUserList(String ownNameJson, String authorizeId) throws IOException {
        ArrayList<BpmDefUser> userList = new ArrayList<BpmDefUser>();
        if (StringUtil.isEmpty((String)ownNameJson)) {
            return userList;
        }
        ArrayNode aryJson = (ArrayNode)JsonUtil.toJsonNode((String)ownNameJson);
        for (Object obj : aryJson) {
            ObjectNode jsonObject = (ObjectNode)obj;
            List<BpmDefUser> list = this.getList(jsonObject, authorizeId);
            userList.addAll(list);
        }
        return userList;
    }

    private List<BpmDefUser> getList(ObjectNode json, String authorizeId) {
        ArrayList<BpmDefUser> bpmDefUsers = new ArrayList<BpmDefUser>();
        String type = json.get("type").asText();
        if ("everyone".equals(type)) {
            BpmDefUser defUser = new BpmDefUser();
            defUser.setId(UniqueIdUtil.getSuid());
            defUser.setAuthorizeId(authorizeId);
            defUser.setRightType(type);
            bpmDefUsers.add(defUser);
        } else {
            String ids = json.get("id").asText();
            String names = json.get("name").asText();
            String[] aryId = ids.split(",");
            String[] aryName = names.split(",");
            for (int i = 0; i < aryId.length; ++i) {
                BpmDefUser defUser = new BpmDefUser();
                defUser.setId(UniqueIdUtil.getSuid());
                defUser.setAuthorizeId(authorizeId);
                defUser.setRightType(type);
                defUser.setOwnerId(aryId[i]);
                defUser.setOwnerName(aryName[i]);
                bpmDefUsers.add(defUser);
            }
        }
        return bpmDefUsers;
    }

    private String toOwnerNameJson(List<BpmDefUser> bpmDefUsers) {
        if (BeanUtils.isEmpty(bpmDefUsers)) {
            return "[]";
        }
        HashMap map = new HashMap();
        Map<String, String> userTypeMap = this.currentUserService.getUserTypeMap(CurrentUserService.DEFAULT_OBJECT_RIGHTTYPE_BEAN);
        for (BpmDefUser user : bpmDefUsers) {
            List<BpmDefUser> list;
            String string = user.getRightType();
            if (map.containsKey(string)) {
                list = (List)map.get(string);
                list.add(user);
                continue;
            }
            list = new ArrayList();
            list.add(user);
            map.put(string, list);
        }
        ArrayNode ArrayNode2 = JsonUtil.getMapper().createArrayNode();
        for (Map.Entry<String, List<BpmDefUser>> entry : map.entrySet()) {
            ObjectNode json = this.userEntToJson(entry, userTypeMap);
            ArrayNode2.add((JsonNode)json);
        }
        return ArrayNode2.toString();
    }

    private ObjectNode userEntToJson(Map.Entry<String, List<BpmDefUser>> entry, Map<String, String> userTypeMap) {
        ObjectNode jsonObj = JsonUtil.getMapper().createObjectNode();
        String type = entry.getKey();
        String title = userTypeMap.get(type);
        jsonObj.put("type", type);
        jsonObj.put("title", title);
        if (type.equals("everyone")) {
            return jsonObj;
        }
        List<BpmDefUser> list = entry.getValue();
        String ids = "";
        String names = "";
        for (int i = 0; i < list.size(); ++i) {
            BpmDefUser user = list.get(i);
            if (i == 0) {
                ids = ids + user.getOwnerId();
                names = names + user.getOwnerName();
                continue;
            }
            ids = ids + "," + user.getOwnerId();
            names = names + "," + user.getOwnerName();
        }
        jsonObj.put("id", ids);
        jsonObj.put("name", names);
        return jsonObj;
    }

    @Override
    public List<String> getAuthorizeIdsByUserMap(String objType) {
        Map<String, Set<String>> userRightMap = this.currentUserService.getUserRightMap();
        Map<String, String> userRightMapStr = this.currentUserService.getMapStringByMayList(userRightMap);
        List<String> list = ((BpmDefUserDao)this.baseMapper).getAuthorizeIdsByUserMap(userRightMapStr, objType);
        return list;
    }

    @Override
    public boolean hasRights(String authorizeId) {
        Map<String, Set<String>> userRightMap = this.currentUserService.getUserRightMap();
        Map<String, String> userRightMapStr = this.currentUserService.getMapStringByMayList(userRightMap);
        List<String> list = ((BpmDefUserDao)this.baseMapper).getAuthByAuthorizeId(userRightMapStr, authorizeId);
        return BeanUtils.isNotEmpty(list);
    }

    @Override
    public List<BpmDefUser> getByUserMap(String objType, String authType) {
        Map<String, Set<String>> userRightMap = this.currentUserService.getUserRightMap();
        Map<String, String> userRightMapStr = this.currentUserService.getMapStringByMayList(userRightMap);
        String atype = StringUtil.isEmpty((String)authType) ? "instance" : authType;
        return ((BpmDefUserDao)this.baseMapper).getByUserMap(userRightMapStr, objType, atype);
    }

    @Override
    @Transactional
    public void delByAuthorizeId(String authorizeId, String bpmDef) {
        ((BpmDefUserDao)this.baseMapper).delByAuthorizeId(authorizeId, bpmDef);
    }

    @Override
    public List<BpmDefUser> getAll(Map<String, Object> params) {
        return ((BpmDefUserDao)this.baseMapper).getAll(params);
    }
}

