/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.persistence.util;

import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.exception.BaseException;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.bpm.api.constant.NodeType;
import com.artfess.bpm.api.model.process.nodedef.BpmNodeDef;
import com.artfess.bpm.api.model.process.nodedef.ext.SubProcessNodeDef;
import com.artfess.bpm.defxml.DefXmlUtil;
import com.artfess.bpm.defxml.entity.Definitions;
import com.artfess.bpm.defxml.entity.Process;
import com.artfess.bpm.defxml.entity.RootElement;
import com.artfess.bpm.defxml.entity.ext.ExtDefinitions;
import com.artfess.bpm.persistence.model.DefaultBpmProcessDef;
import com.artfess.bpm.persistence.util.BpmProcessDefExtParse;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;

public class BpmnXmlValidateUtil {
    public static ObjectNode vilateBpmXml(List<BpmNodeDef> nodeDefs) {
        boolean isTrue = false;
        ObjectNode msg = JsonUtil.getMapper().createObjectNode();
        ObjectNode errors = JsonUtil.getMapper().createObjectNode();
        isTrue = BpmnXmlValidateUtil.vilate(nodeDefs, errors);
        msg.put("isTrue", isTrue);
        String errorMsg = isTrue ? "" : BpmnXmlValidateUtil.getResultMsg(errors);
        msg.put("errorMsgs", errorMsg);
        return msg;
    }

    private static boolean vilate(List<BpmNodeDef> nodeDefs, ObjectNode errors) {
        boolean isTrue = false;
        boolean isSequenceTrue = BpmnXmlValidateUtil.vilateSequence(nodeDefs, errors);
        boolean isGateway = BpmnXmlValidateUtil.vilateGateways(nodeDefs, errors);
        boolean isSubProcess = BpmnXmlValidateUtil.vilateSubProcess(nodeDefs, errors);
        if (isSequenceTrue && isGateway && isSubProcess) {
            isTrue = true;
        }
        return isTrue;
    }

    private static String getResultMsg(ObjectNode errors) {
        StringBuffer msg = new StringBuffer();
        int index = 1;
        Iterator sIterator = errors.fieldNames();
        while (sIterator.hasNext()) {
            String key = (String)sIterator.next();
            String value = errors.get(key).asText();
            msg.append("\u9519\u8bef\u6d88\u606f" + index + "\u3001");
            msg.append(value);
            msg.append("\uff1b");
            ++index;
        }
        return msg.toString();
    }

    public static List<BpmNodeDef> getNodeDefs(String bpmnXml) throws Exception {
        DefaultBpmProcessDef bpmProcessDef = null;
        try {
            bpmProcessDef = BpmnXmlValidateUtil.getByBpmnXml(bpmnXml);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bpmProcessDef.getBpmnNodeDefs();
    }

    public static DefaultBpmProcessDef getByBpmnXml(String bpmnXml) throws Exception {
        ExtDefinitions definition = DefXmlUtil.getDefinitionsByXml(bpmnXml);
        if (definition == null) {
            return null;
        }
        List<Process> list = BpmnXmlValidateUtil.getProcess(definition);
        if (list.size() != 1) {
            throw new BaseException(ResponseErrorEnums.BPM_PROCESS);
        }
        Process process = list.get(0);
        DefaultBpmProcessDef bpmProcessDef = new DefaultBpmProcessDef();
        bpmProcessDef.setName(process.getName());
        bpmProcessDef.setDefKey(process.getId());
        BpmProcessDefExtParse processDefExtParse = BpmProcessDefExtParse.getInstance();
        processDefExtParse.handProcessDef(bpmProcessDef, definition, process);
        return bpmProcessDef;
    }

    private static List<Process> getProcess(Definitions definitions) throws JAXBException, IOException {
        ArrayList<Process> processes = new ArrayList<Process>();
        List<JAXBElement<? extends RootElement>> bPMNElements = definitions.getRootElement();
        for (JAXBElement<? extends RootElement> jAXBe : bPMNElements) {
            RootElement element = (RootElement)jAXBe.getValue();
            if (!(element instanceof Process)) continue;
            processes.add((Process)element);
        }
        return processes;
    }

    private static boolean vilateGateways(List<BpmNodeDef> nodeDefs, ObjectNode errors) {
        boolean isTrue = true;
        int inclus = 0;
        int parallels = 0;
        for (BpmNodeDef bpmNodeDef : nodeDefs) {
            if (bpmNodeDef.getType().equals((Object)NodeType.PARALLELGATEWAY)) {
                ++parallels;
                continue;
            }
            if (!bpmNodeDef.getType().equals((Object)NodeType.INCLUSIVEGATEWAY)) continue;
            ++inclus;
        }
        if (parallels > 0 && parallels % 2 != 0) {
            isTrue = false;
            BpmnXmlValidateUtil.putMsgs(errors, "\u6d41\u7a0b\u5b9a\u4e49\u4e2d\u540c\u6b65\u7f51\u5173\u672a\u6210\u5bf9\u51fa\u73b0", "tbwg");
        }
        if (inclus > 0 && inclus % 2 != 0) {
            isTrue = false;
            BpmnXmlValidateUtil.putMsgs(errors, "\u6d41\u7a0b\u5b9a\u4e49\u4e2d\u6761\u4ef6\u7f51\u5173\u672a\u6210\u5bf9\u51fa\u73b0", "tjwg");
        }
        return isTrue;
    }

    private static boolean vilateSequence(List<BpmNodeDef> nodeDefs, ObjectNode errors) {
        boolean isTrue = true;
        boolean isStart = false;
        boolean isEnd = false;
        BpmNodeDef parentBpmNodeDef = null;
        for (BpmNodeDef bpmNodeDef : nodeDefs) {
            if (!(BeanUtils.isNotEmpty(bpmNodeDef.getIncomeNodes()) && BeanUtils.isNotEmpty(bpmNodeDef.getOutcomeNodes()) || bpmNodeDef.getType().equals((Object)NodeType.START) || bpmNodeDef.getType().equals((Object)NodeType.END))) {
                if (BeanUtils.isEmpty(bpmNodeDef.getIncomeNodes()) && BeanUtils.isEmpty(bpmNodeDef.getOutcomeNodes())) {
                    BpmnXmlValidateUtil.putMsgs(errors, "\u8282\u70b9\u3010" + bpmNodeDef.getName() + "\u3011\u7f3a\u5c11\u6d41\u5165\u548c\u6d41\u51fa", bpmNodeDef.getName());
                } else if (BeanUtils.isEmpty(bpmNodeDef.getIncomeNodes()) && BeanUtils.isNotEmpty(bpmNodeDef.getOutcomeNodes())) {
                    BpmnXmlValidateUtil.putMsgs(errors, "\u8282\u70b9\u3010" + bpmNodeDef.getName() + "\u3011\u7f3a\u5c11\u6d41\u5165", bpmNodeDef.getName());
                } else {
                    BpmnXmlValidateUtil.putMsgs(errors, "\u8282\u70b9\u3010" + bpmNodeDef.getName() + "\u3011\u7f3a\u5c11\u6d41\u51fa", bpmNodeDef.getName());
                }
                isTrue = false;
                if (!BeanUtils.isEmpty((Object)parentBpmNodeDef) || !BeanUtils.isNotEmpty((Object)bpmNodeDef.getParentBpmNodeDef())) continue;
                parentBpmNodeDef = bpmNodeDef.getParentBpmNodeDef();
                continue;
            }
            if (BeanUtils.isEmpty(bpmNodeDef.getOutcomeNodes()) && bpmNodeDef.getType().equals((Object)NodeType.START)) {
                BpmnXmlValidateUtil.putMsgs(errors, "\u6d41\u7a0b\u5b9a\u4e49\u4e2d\u5b58\u5728\u65e0\u6548\u7684\u5f00\u59cb\u8282\u70b9\u3010" + bpmNodeDef.getName() + "\u3011\uff08\u7f3a\u5c11\u6d41\u51fa\uff09", bpmNodeDef.getName());
                isTrue = false;
                isStart = true;
                continue;
            }
            if (BeanUtils.isEmpty(bpmNodeDef.getIncomeNodes()) && bpmNodeDef.getType().equals((Object)NodeType.END)) {
                BpmnXmlValidateUtil.putMsgs(errors, "\u6d41\u7a0b\u5b9a\u4e49\u4e2d\u5b58\u5728\u65e0\u6548\u7684\u7ed3\u675f\u8282\u70b9\u3010" + bpmNodeDef.getName() + "\u3011\uff08\u7f3a\u5c11\u6d41\u5165\uff09", bpmNodeDef.getName());
                isTrue = false;
                isEnd = true;
                continue;
            }
            if (bpmNodeDef.getType().equals((Object)NodeType.END)) {
                isEnd = true;
                continue;
            }
            if (!bpmNodeDef.getType().equals((Object)NodeType.START)) continue;
            isStart = true;
            List<BpmNodeDef> outNodes = bpmNodeDef.getOutcomeNodes();
            for (BpmNodeDef outNodeDef : outNodes) {
                if (outNodeDef.getType().equals((Object)NodeType.USERTASK)) continue;
                isTrue = false;
                BpmnXmlValidateUtil.putMsgs(errors, "\u5f00\u59cb\u8282\u70b9\u3010" + bpmNodeDef.getName() + "\u3011\u8fde\u63a5\u7684\u8282\u70b9\u3010" + outNodeDef.getName() + "\u3011\u4e3a\u975e\u7528\u6237\u4efb\u52a1\uff08\u5f00\u59cb\u8282\u70b9\u53ea\u80fd\u8fde\u63a5\u7528\u6237\u4efb\u52a1\uff09", bpmNodeDef.getName());
            }
        }
        if (!isEnd) {
            if (BeanUtils.isNotEmpty(parentBpmNodeDef)) {
                BpmnXmlValidateUtil.putMsgs(errors, "\u3010" + parentBpmNodeDef.getName() + "\u3011\u4e2d\u7f3a\u5c11\u7ed3\u675f\u8282\u70b9", "end" + parentBpmNodeDef.getNodeId());
            } else {
                BpmnXmlValidateUtil.putMsgs(errors, "\u6d41\u7a0b\u5b9a\u4e49\u4e2d\u7f3a\u5c11\u7ed3\u675f\u8282\u70b9", "end");
            }
            isTrue = false;
        }
        if (!isStart) {
            if (BeanUtils.isNotEmpty(parentBpmNodeDef)) {
                BpmnXmlValidateUtil.putMsgs(errors, "\u3010" + parentBpmNodeDef.getName() + "\u3011\u4e2d\u7f3a\u5c11\u5f00\u59cb\u8282\u70b9", "start" + parentBpmNodeDef.getNodeId());
            } else {
                BpmnXmlValidateUtil.putMsgs(errors, "\u6d41\u7a0b\u5b9a\u4e49\u4e2d\u7f3a\u5c11\u5f00\u59cb\u8282\u70b9", "start");
            }
            isTrue = false;
        }
        return isTrue;
    }

    private static boolean vilateSubProcess(List<BpmNodeDef> nodeDefs, ObjectNode errors) {
        boolean isTrue = true;
        for (BpmNodeDef bpmNodeDef : nodeDefs) {
            SubProcessNodeDef node;
            List<BpmNodeDef> subProNodes;
            if (!bpmNodeDef.getType().equals((Object)NodeType.SUBPROCESS) || !(bpmNodeDef instanceof SubProcessNodeDef) || BpmnXmlValidateUtil.vilate(subProNodes = (node = (SubProcessNodeDef)bpmNodeDef).getChildBpmProcessDef().getBpmnNodeDefs(), errors)) continue;
            isTrue = false;
        }
        return isTrue;
    }

    private static void putMsgs(ObjectNode errors, String msg, String node) {
        errors.put(node, msg);
    }
}

