/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.persistence.manager.impl;

import com.artfess.base.conf.SaaSConfig;
import com.artfess.base.context.BaseContext;
import com.artfess.base.feign.ApplicationFeignService;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.groovy.GroovyScriptEngine;
import com.artfess.base.handler.MultiTenantHandler;
import com.artfess.base.handler.MultiTenantIgnoreResult;
import com.artfess.base.jms.JmsActor;
import com.artfess.base.jms.Notice;
import com.artfess.base.jms.NoticeMessageType;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.template.impl.FreeMarkerEngine;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.SQLUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.base.util.time.DateFormatUtil;
import com.artfess.base.util.time.DateUtil;
import com.artfess.base.util.time.TimeUtil;
import com.artfess.bpm.api.cmd.ActionCmd;
import com.artfess.bpm.api.context.ContextThreadUtil;
import com.artfess.bpm.api.helper.identity.BpmIdentityExtractService;
import com.artfess.bpm.api.model.identity.BpmIdentity;
import com.artfess.bpm.api.model.process.inst.BpmProcessInstance;
import com.artfess.bpm.api.service.BoDataService;
import com.artfess.bpm.api.service.BpmIdentityService;
import com.artfess.bpm.api.service.BpmInstService;
import com.artfess.bpm.api.service.BpmTaskActionService;
import com.artfess.bpm.engine.task.cmd.DefaultTaskFinishCmd;
import com.artfess.bpm.natapi.task.NatTaskService;
import com.artfess.bpm.persistence.dao.BpmTaskReminderDao;
import com.artfess.bpm.persistence.manager.BpmCheckOpinionManager;
import com.artfess.bpm.persistence.manager.BpmExeStackExecutorManager;
import com.artfess.bpm.persistence.manager.BpmExeStackRelationManager;
import com.artfess.bpm.persistence.manager.BpmReminderHistoryManager;
import com.artfess.bpm.persistence.manager.BpmSecretaryManageManager;
import com.artfess.bpm.persistence.manager.BpmTaskManager;
import com.artfess.bpm.persistence.manager.BpmTaskReminderManager;
import com.artfess.bpm.persistence.model.BpmExeStackExecutor;
import com.artfess.bpm.persistence.model.BpmExeStackRelation;
import com.artfess.bpm.persistence.model.BpmReminderHistory;
import com.artfess.bpm.persistence.model.BpmTaskReminder;
import com.artfess.bpm.persistence.model.DefaultBpmCheckOpinion;
import com.artfess.bpm.persistence.model.DefaultBpmTask;
import com.artfess.bpm.util.MessageUtil;
import com.artfess.bpm.util.PortalDataUtil;
import com.artfess.uc.api.impl.model.UserFacade;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bpmTaskReminderManager")
public class BpmTaskReminderManagerImpl
extends BaseManagerImpl<BpmTaskReminderDao, BpmTaskReminder>
implements BpmTaskReminderManager {
    @Resource
    BpmTaskManager bpmTaskManager;
    @Resource
    BpmIdentityService bpmIdentityService;
    @Resource
    BpmIdentityExtractService bpmIdentityExtractService;
    @Resource
    BpmReminderHistoryManager bpmReminderHistoryManager;
    @Resource
    NatTaskService natTaskService;
    @Resource
    BpmInstService bpmInstService;
    @Resource
    BoDataService boDataService;
    @Resource
    GroovyScriptEngine groovyScriptEngine;
    @Resource
    UCFeignService ucFeignService;
    @Resource
    BaseContext baseContext;
    @Autowired
    SaaSConfig saaSConfig;
    @Autowired
    BpmExeStackRelationManager bpmExeStackRelationManager;
    @Autowired
    BpmExeStackExecutorManager bpmExeStackExecutorManager;
    @Autowired
    BpmCheckOpinionManager bpmCheckOpinionManager;

    @Override
    @Transactional
    public void deleteByTaskId(String taskId) {
        ((BpmTaskReminderDao)this.baseMapper).deleteByTaskId(taskId);
    }

    @Override
    public List<BpmTaskReminder> getTriggerReminders() {
        String currentTime = TimeUtil.getCurrentTime();
        String timeSql = " trigger_date_ <='" + currentTime + "'";
        String dbType = SQLUtil.getDbType();
        if ("oracle".equals(dbType)) {
            timeSql = " trigger_date_ <= to_date('" + currentTime + "','yyyy-mm-dd hh24:mi:ss') ";
        }
        ArrayList<BpmTaskReminder> list = new ArrayList();
        try (MultiTenantIgnoreResult setThreadLocalIgnore = MultiTenantHandler.setThreadLocalIgnore();){
            list = ((BpmTaskReminderDao)this.baseMapper).getTriggerReminders(timeSql);
        }
        catch (Exception e) {
            System.out.println("\u83b7\u53d6\u50ac\u529e\u4efb\u52a1\u5931\u8d25\uff1a" + e.getMessage());
        }
        return list;
    }

    @Override
    public void executeTaskReminderJob() throws Exception {
        List<BpmTaskReminder> reminderList = this.getTriggerReminders();
        for (BpmTaskReminder reminder : reminderList) {
            try {
                this.doTaskReminderJob(reminder);
            }
            catch (Exception e) {
                System.out.println("\u50ac\u529e\u6267\u884c\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
    }

    @Transactional
    public void doTaskReminderJob(BpmTaskReminder reminder) throws Exception {
        DefaultBpmTask task;
        if (this.saaSConfig.isEnable()) {
            this.baseContext.setTempTenantId(reminder.getTenantId());
        }
        if (BeanUtils.isEmpty((Object)(task = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)reminder.getTaskId()))))) {
            this.remove((Serializable)((Object)reminder.getId()));
            return;
        }
        this.setCurrentUser(task);
        task.setIdentityList(this.bpmIdentityService.searchByNode(task.getProcInstId(), task.getNodeId()));
        BpmProcessInstance inst = this.bpmInstService.getProcessInstance(task.getProcInstId());
        if (inst.getIsForbidden() == BpmProcessInstance.FORBIDDEN_YES.intValue()) {
            return;
        }
        boolean taskComplate = this.executeDueAction(reminder, task);
        if (reminder.getIsSendMsg() == 1) {
            this.sendMsg(reminder, task);
        }
        if (taskComplate) {
            return;
        }
        this.handleWarning(reminder, task);
        if ("no-action".equals(reminder.getDueAction()) && (reminder.getIsSendMsg() == 0 || reminder.getMsgCount() <= 0) && StringUtil.isEmpty((String)reminder.getWarningset())) {
            this.remove((Serializable)((Object)reminder.getId()));
            return;
        }
        this.update((Model)reminder);
    }

    private void setCurrentUser(DefaultBpmTask task) throws IOException {
        IUser user = null;
        List<BpmExeStackRelation> stackRelations = this.bpmExeStackRelationManager.getByToNodeId(task.getProcInstId(), task.getNodeId());
        if (BeanUtils.isNotEmpty(stackRelations)) {
            List<BpmExeStackExecutor> executors = this.bpmExeStackExecutorManager.getByStackId(stackRelations.get(0).getFromStackId());
            if (BeanUtils.isNotEmpty(executors) && executors.size() == 1) {
                user = this.getUser(executors.get(0).getAssigneeId(), null);
            } else {
                BpmExeStackExecutor executor;
                String dbType = SQLUtil.getDbType();
                DefaultBpmCheckOpinion opinion = this.bpmCheckOpinionManager.getBpmOpinion(task.getProcInstId(), stackRelations.get(0).getFromNodeId(), dbType);
                if (BeanUtils.isNotEmpty((Object)opinion) && StringUtil.isNotEmpty((String)opinion.getTaskId()) && BeanUtils.isNotEmpty((Object)((Object)(executor = this.bpmExeStackExecutorManager.getByTaskId(opinion.getTaskId()))))) {
                    user = this.getUser(executor.getAssigneeId(), null);
                }
            }
        } else {
            user = this.getUser(null, "admin");
        }
        if (BeanUtils.isNotEmpty((Object)user)) {
            ContextUtil.setCurrentUserInJob((IUser)user);
        }
    }

    private IUser getUser(String id, String account) throws IOException {
        JsonNode node;
        if (StringUtil.isNotEmpty((String)id)) {
            CommonResult node2 = this.ucFeignService.getUserById(id);
            if (node2.getState().booleanValue()) {
                UserFacade user = (UserFacade)JsonUtil.toBean((JsonNode)((JsonNode)node2.getValue()), UserFacade.class);
                return user;
            }
        } else if (StringUtil.isNotEmpty((String)account) && BeanUtils.isNotEmpty((Object)(node = this.ucFeignService.getUser(account, "")))) {
            UserFacade user = (UserFacade)JsonUtil.toBean((JsonNode)node, UserFacade.class);
            return user;
        }
        return null;
    }

    @Override
    public CommonResult<String> modifyTaskReminder(String instId) throws Exception {
        BpmProcessInstance bpmProcessInstance = this.bpmInstService.getProcessInstance(instId);
        List<ObjectNode> boDatas = this.boDataService.getDataByInst(bpmProcessInstance);
        Map<String, Object> map = boDatas.stream().collect(Collectors.toMap(item -> {
            if (item.hasNonNull("boDefAlias")) {
                return item.get("boDefAlias").asText();
            }
            return item.get("boDef").get("alias").asText();
        }, item -> item.get("data")));
        List<DefaultBpmTask> tasks = this.bpmTaskManager.getByInstId(instId);
        tasks.forEach(task -> {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"task_id_", (Object)task.getId());
            List reminders = this.list((Wrapper)wrapper);
            reminders.forEach(reminder -> {
                try {
                    this.executeScript((BpmTaskReminder)((Object)((Object)reminder)), map);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        });
        return new CommonResult(true, "\u4fee\u6539\u6210\u529f");
    }

    @Override
    public void executeScript(BpmTaskReminder reminder, Map<String, Object> map) throws Exception {
        if (StringUtil.isNotEmpty((String)reminder.getTypeScript())) {
            JsonNode node;
            JsonNode type = (JsonNode)this.groovyScriptEngine.executeObject(reminder.getTypeScript(), map);
            LocalDateTime dueDate = reminder.getDueDate();
            LocalDateTime msgBeginDate = reminder.getMsgSendDate();
            int dueTime = 0;
            int relTime = 0;
            if (StringUtil.isNotEmpty((String)reminder.getDurationScript()) && BeanUtils.isNotEmpty((Object)(node = (JsonNode)this.groovyScriptEngine.executeObject(reminder.getDurationScript(), map)))) {
                dueTime = node.asInt();
            }
            if (StringUtil.isNotEmpty((String)reminder.getRelTimeScript()) && BeanUtils.isNotEmpty((Object)(node = (JsonNode)this.groovyScriptEngine.executeObject(reminder.getRelTimeScript(), map)))) {
                relTime = node.asInt();
            }
            if ("caltime".equals(type.asText())) {
                dueDate = TimeUtil.getLocalDateTimeByMills((long)TimeUtil.getNextTime((int)1, (int)dueTime, (long)TimeUtil.getTimeMillis((LocalDateTime)reminder.getRelDate())));
                msgBeginDate = TimeUtil.getLocalDateTimeByMills((long)TimeUtil.getNextTime((int)1, (int)relTime, (long)TimeUtil.getTimeMillis((LocalDateTime)reminder.getRelDate())));
            } else {
                long sendTime = DateUtil.getCurrentTimeInMillis();
                long msgSendTime = DateUtil.getCurrentTimeInMillis();
                if (StringUtil.isNotEmpty((String)reminder.getSendUserId())) {
                    sendTime = this.ucFeignService.computeSendDate(reminder.getSendUserId(), (long)(dueTime * 60));
                }
                dueDate = LocalDateTime.ofEpochSecond(sendTime / 1000L, 0, ZoneOffset.ofHours(8));
                msgSendTime = this.ucFeignService.computeSendDate(reminder.getId(), (long)(relTime * 60));
                msgBeginDate = LocalDateTime.ofEpochSecond(msgSendTime / 1000L, 0, ZoneOffset.ofHours(8));
            }
            reminder.setDueDate(dueDate);
            reminder.setMsgSendDate(msgBeginDate);
            if (msgBeginDate.isBefore(dueDate)) {
                reminder.setTriggerDate(msgBeginDate);
            }
        } else {
            throw new RuntimeException("\u672a\u8bbe\u7f6e\u811a\u672c\u83b7\u53d6\u65e5\u671f\u7c7b\u578b");
        }
        this.update((Model)reminder);
    }

    @Override
    public void forbiddenTaskReminder(String instId) {
        List<DefaultBpmTask> tasks = this.bpmTaskManager.getByInstId(instId);
        List taskIds = tasks.stream().map(DefaultBpmTask::getId).collect(Collectors.toList());
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"task_id_", taskIds);
        List reminders = this.list((Wrapper)wrapper);
        reminders.forEach(reminder -> {
            long duration = 0L;
            long sendDuration = 0L;
            if ("caltime".equals(reminder.getDateType())) {
                duration = TimeUtil.getTimeMillis((LocalDateTime)reminder.getTriggerDate()) - DateUtil.getCurrentTimeInMillis();
                if (TimeUtil.getTimeMillis((LocalDateTime)reminder.getMsgSendDate()) - DateUtil.getCurrentTimeInMillis() > 0L) {
                    sendDuration = TimeUtil.getTimeMillis((LocalDateTime)reminder.getMsgSendDate()) - DateUtil.getCurrentTimeInMillis();
                }
            } else {
                ObjectNode param = JsonUtil.getMapper().createObjectNode();
                param.put("startDate", DateUtil.getCurrentTime());
                param.put("endDate", DateFormatUtil.format((LocalDateTime)reminder.getTriggerDate(), (String)"yyyy-MM-dd HH:mm:ss"));
                try {
                    duration = this.ucFeignService.computeDuration(reminder.getSendUserId(), param);
                    param.put("endDate", DateFormatUtil.format((LocalDateTime)reminder.getMsgSendDate(), (String)"yyyy-MM-dd HH:mm:ss"));
                    sendDuration = this.ucFeignService.computeDuration(reminder.getSendUserId(), param);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            reminder.setDuration(duration);
            reminder.setSendDuration(sendDuration);
            reminder.setTriggerDate(null);
            this.update((Model)reminder);
        });
    }

    @Override
    public void allowTaskReminder(String instId) {
        List<DefaultBpmTask> tasks = this.bpmTaskManager.getByInstId(instId);
        List taskIds = tasks.stream().map(DefaultBpmTask::getId).collect(Collectors.toList());
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"task_id_", taskIds);
        List reminders = this.list((Wrapper)wrapper);
        reminders.forEach(reminder -> {
            LocalDateTime msgBeginDate = null;
            if ("caltime".equals(reminder.getDateType())) {
                try {
                    LocalDateTime dueDate = TimeUtil.getLocalDateTimeByMills((long)TimeUtil.getNextTime((int)0, (int)(reminder.getDuration().intValue() / 1000), (long)TimeUtil.getTimeMillis((LocalDateTime)LocalDateTime.now())));
                    if (reminder.getIsSendMsg() == 1) {
                        msgBeginDate = TimeUtil.getLocalDateTimeByMills((long)TimeUtil.getNextTime((int)0, (int)(reminder.getSendDuration().intValue() / 1000), (long)TimeUtil.getTimeMillis((LocalDateTime)LocalDateTime.now())));
                    }
                    reminder.setDueDate(dueDate);
                    reminder.setTriggerDate(dueDate);
                    reminder.setMsgSendDate(msgBeginDate);
                    this.update((Model)reminder);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                Long msgSendTime = null;
                try {
                    Long sendTime = this.ucFeignService.computeSendDate(reminder.getSendUserId(), reminder.getDuration() / 1000L / 60L);
                    LocalDateTime dueDate = TimeUtil.getLocalDateTimeByMills((long)sendTime);
                    if (reminder.getIsSendMsg() == 1) {
                        msgSendTime = this.ucFeignService.computeSendDate(reminder.getSendUserId(), reminder.getSendDuration() / 1000L / 60L);
                        msgBeginDate = TimeUtil.getLocalDateTimeByMills((long)msgSendTime);
                    }
                    reminder.setDueDate(dueDate);
                    reminder.setTriggerDate(dueDate);
                    reminder.setMsgSendDate(msgBeginDate);
                    this.update((Model)reminder);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Transactional
    private void handleWarning(BpmTaskReminder reminder, DefaultBpmTask task) throws IOException {
        if (StringUtil.isEmpty((String)reminder.getWarningset())) {
            return;
        }
        ArrayNode newWarningSet = JsonUtil.getMapper().createArrayNode();
        ArrayNode array = (ArrayNode)JsonUtil.toJsonNode((String)reminder.getWarningset());
        for (int i = 0; i < array.size(); ++i) {
            ObjectNode warn = (ObjectNode)array.get(i);
            LocalDateTime warningDate = TimeUtil.convertString((String)warn.get("warnDate").asText());
            if (warningDate.isBefore(LocalDateTime.now())) {
                task.setPriority(warn.get("level").asLong());
                this.bpmTaskManager.updateTaskPriority(task.getId(), warn.get("level").asLong());
                this.createReminderHistory(reminder, "Warning", warn.get("warnName").asText(), task);
                continue;
            }
            if (warningDate.isBefore(reminder.getTriggerDate())) {
                reminder.setTriggerDate(warningDate);
            }
            newWarningSet.add((JsonNode)warn);
        }
        if (newWarningSet.size() > 0) {
            reminder.setWarningset(JsonUtil.toJson((Object)newWarningSet));
        } else {
            reminder.setWarningset("");
        }
    }

    @Transactional
    private boolean executeDueAction(BpmTaskReminder reminder, DefaultBpmTask task) {
        ActionCmd actionCmd = ContextThreadUtil.getActionCmd();
        if (BeanUtils.isEmpty((Object)actionCmd)) {
            actionCmd = new DefaultTaskFinishCmd();
        }
        actionCmd.addVariable("instanceId_", task.getProcInstId());
        if (reminder.getDueDate().isAfter(LocalDateTime.now())) {
            reminder.setTriggerDate(reminder.getDueDate());
            return false;
        }
        if ("no-action".equals(reminder.getDueAction())) {
            return false;
        }
        String msg = "";
        BpmTaskActionService bpmTaskActionService = (BpmTaskActionService)AppUtil.getBean(BpmTaskActionService.class);
        if ("auto-next".equals(reminder.getDueAction())) {
            DefaultTaskFinishCmd taskFinishCmd = new DefaultTaskFinishCmd();
            taskFinishCmd.setTaskId(reminder.getTaskId());
            taskFinishCmd.setActionName("agree");
            taskFinishCmd.setApprovalOpinion("\u50ac\u529e\u5230\u671f\u81ea\u52a8\u5b8c\u6210");
            try {
                bpmTaskActionService.finishTask(taskFinishCmd);
                msg = "\u5df2\u7ecf\u81ea\u52a8\u5b8c\u6210\u5f53\u524d\u4efb\u52a1\uff01";
                this.deleteByTaskId(reminder.getTaskId());
            }
            catch (Exception e) {
                msg = "\u81ea\u52a8\u5b8c\u6210\u5f53\u524d\u4efb\u52a1\u5931\u8d25\uff01\uff1a" + e.getMessage();
                e.printStackTrace();
            }
        } else if ("end-process".equals(reminder.getDueAction())) {
            try {
                bpmTaskActionService.endProcessByTaskId(reminder.getTaskId(), reminder.getMsgType(), "\u50ac\u529e\u4efb\u52a1\u5230\u671f\uff0c\u81ea\u52a8\u7ed3\u675f\u6d41\u7a0b\uff01", "");
                this.deleteByTaskId(reminder.getTaskId());
                msg = "\u5df2\u7ecf\u7ed3\u675f\u5f53\u524d\u6d41\u7a0b\uff01";
            }
            catch (Exception e) {
                msg = "\u81ea\u52a8\u7ed3\u675f\u5f53\u524d\u6d41\u7a0b\u5931\u8d25\uff01\uff1a" + e.getMessage();
                e.printStackTrace();
            }
        } else if ("call-method".equals(reminder.getDueAction()) && StringUtil.isNotEmpty((String)reminder.getDueScript())) {
            Map<Object, Object> vars = new HashMap();
            vars = this.natTaskService.getVariables(reminder.getTaskId());
            Map<String, Object> variables = vars;
            vars.putAll(variables);
            vars.put("task", task);
            GroovyScriptEngine groovyScriptEngine = (GroovyScriptEngine)AppUtil.getBean(GroovyScriptEngine.class);
            try {
                groovyScriptEngine.execute(reminder.getDueScript(), vars);
            }
            catch (Exception e) {
                this.createReminderHistory(reminder, reminder.getDueAction(), "\u6267\u884c\u811a\u672c" + reminder.getDueScript() + "\n\u5931\u8d25\uff01" + e.getMessage(), task);
            }
            reminder.setDueAction("no-action");
            this.createReminderHistory(reminder, reminder.getDueAction(), "\u6267\u884c\u811a\u672c\u6210\u529f\uff1a" + reminder.getDueScript(), task);
            return false;
        }
        this.createReminderHistory(reminder, reminder.getDueAction(), msg, task);
        return true;
    }

    @Transactional
    private void sendMsg(BpmTaskReminder reminder, DefaultBpmTask task) throws Exception {
        String text;
        String html;
        LocalDateTime beginSend = reminder.getMsgSendDate();
        int count = reminder.getMsgCount();
        if (beginSend.isAfter(LocalDateTime.now()) || count <= 0) {
            return;
        }
        int interval = BeanUtils.isNotEmpty((Object)reminder.getMsgInterval()) ? reminder.getMsgInterval() : 1;
        reminder.setMsgSendDate(TimeUtil.getLocalDateTimeByMills((long)TimeUtil.getNextTime((int)1, (int)interval, (long)TimeUtil.getTimeMillis((LocalDateTime)beginSend))));
        reminder.setMsgCount(count - 1);
        if (reminder.getMsgSendDate().isBefore(reminder.getTriggerDate())) {
            reminder.setTriggerDate(reminder.getMsgSendDate());
        }
        FreeMarkerEngine FreeMarkerEngine2 = (FreeMarkerEngine)AppUtil.getBean(FreeMarkerEngine.class);
        HashMap<String, Object> vars = new HashMap<String, Object>();
        IUser currentUser = ContextUtil.getCurrentUser();
        vars.put("title", task.getSubject());
        vars.put("time", reminder.getRelDate());
        vars.put("task", task);
        vars.put("startorName", currentUser.getFullname());
        vars.put("startDate", DateUtil.getCurrentTime((String)"yyyy-MM-dd"));
        vars.put("flowKey_", task.getProcDefKey());
        vars.put("instanceId_", task.getProcInstId());
        vars.put("startUser", currentUser.getFullname());
        BpmProcessInstance bpmProcessInstance = this.bpmInstService.getProcessInstance(task.getProcInstId());
        try {
            String baseUrl = PortalDataUtil.getPropertyByAlias("baseUrl");
            vars.put("baseUrl", baseUrl);
            vars.put("instId", task.getProcInstId());
            vars.put("taskId", task.getId());
            vars.put("taskSubject", task.getSubject());
            vars.put("nodeName", task.getName());
            vars.put("instSubject", task.getSubject());
            vars.put("date", bpmProcessInstance.getCreateTime());
            vars.put("creator", bpmProcessInstance.getCreator());
            vars.put("bpmName", task.getProcDefName());
            vars.put("cause", "\u50ac\u529e\u6d88\u606f\u63d0\u9192");
            vars.put("sender", currentUser.getFullname());
            vars.put("delegate", currentUser.getFullname());
            vars.put("agent", currentUser.getFullname());
        }
        catch (Exception e) {
            System.out.println("\u8bbe\u7f6e\u53d8\u91cf\u51fa\u9519\uff1a" + e.getMessage());
        }
        List<ObjectNode> boDatas = this.boDataService.getDataByInst(bpmProcessInstance);
        if (BeanUtils.isNotEmpty(boDatas)) {
            for (ObjectNode objectNode : boDatas) {
                String boName = "";
                boName = objectNode.hasNonNull("boDefAlias") ? objectNode.get("boDefAlias").asText() : objectNode.get("boDef").get("alias").asText();
                Map dataMap = new HashMap();
                try {
                    dataMap = JsonUtil.toMap((String)JsonUtil.toJson((Object)objectNode.get("data")));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                for (Map.Entry entry : dataMap.entrySet()) {
                    vars.put(boName + "." + (String)entry.getKey(), entry.getValue());
                }
            }
        }
        try {
            html = StringUtil.getStrByRule((String)reminder.getHtmlMsg(), vars);
            text = FreeMarkerEngine2.parseByTemplate(reminder.getPlainMsg(), vars);
        }
        catch (Exception e) {
            this.createReminderHistory(reminder, "sendMsg", "\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff01" + e.getMessage(), task);
            return;
        }
        String userNames = "";
        List<Object> recievers = new ArrayList();
        recievers = this.bpmIdentityExtractService.extractUser(this.bpmIdentityService.searchByNode(task.getProcInstId(), task.getNodeId()));
        Map<String, IUser> reciversMap = recievers.stream().collect(Collectors.toMap(item -> item.getUserId(), item -> item));
        HashSet<String> leaderIdSet = new HashSet<String>();
        if (StringUtil.isNotZeroEmpty((String)task.getOwnerId())) {
            userNames = task.getOwnerName();
            leaderIdSet.add(task.getOwnerId());
        } else {
            for (BpmIdentity identity : task.getIdentityList()) {
                userNames = userNames + identity.getName() + ",";
                leaderIdSet.add(identity.getId());
            }
        }
        HashSet<String> secreIdSet = new HashSet<String>();
        if ("1".equals(reminder.getSendPerson())) {
            if (BeanUtils.isNotEmpty((Object)reminder.getSendUserId())) {
                IUser user = reciversMap.get(reminder.getSendUserId());
                if (BeanUtils.isNotEmpty((Object)user)) {
                    recievers = new ArrayList();
                    recievers.add(user);
                    userNames = user.getFullname();
                }
            } else {
                BpmSecretaryManageManager bManage = (BpmSecretaryManageManager)AppUtil.getBean(BpmSecretaryManageManager.class);
                Map<String, Set<String>> secretarys = bManage.getSecretaryByleaderIds(leaderIdSet, task.getProcDefKey());
                Iterator<Map.Entry<String, Set<String>>> iterator = secretarys.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, Set<String>> next = iterator.next();
                    if (StringUtil.isEmpty((String)next.getKey())) {
                        iterator.remove();
                    }
                    Iterator<String> iterator2 = next.getValue().iterator();
                    while (iterator2.hasNext()) {
                        String secreId = iterator2.next();
                        if (leaderIdSet.contains(secreId) || StringUtil.isEmpty((String)secreId)) {
                            iterator2.remove();
                            continue;
                        }
                        secreIdSet.add(secreId);
                    }
                }
                HashMap<String, ObjectNode> userMap = new HashMap<String, ObjectNode>();
                if (!secreIdSet.isEmpty()) {
                    UCFeignService ucFeignService = (UCFeignService)AppUtil.getBean(UCFeignService.class);
                    HashSet<String> userIdSet = new HashSet<String>();
                    userIdSet.addAll(leaderIdSet);
                    userIdSet.addAll(secreIdSet);
                    ArrayNode user = ucFeignService.getUserByIdsOrAccounts(StringUtil.join(userIdSet));
                    for (JsonNode jsonNode : user) {
                        ObjectNode userNode = (ObjectNode)jsonNode;
                        userMap.put(userNode.get("id").asText(), userNode);
                    }
                    HashSet<String> sendSecretaryName = new HashSet<String>();
                    for (Map.Entry<String, Set<String>> next : secretarys.entrySet()) {
                        String subject = "\u3010" + ((ObjectNode)userMap.get(next.getKey())).get("fullname").asText() + "\u3011\u5171\u4eab\u4efb\u52a1\u50ac\u529e";
                        ArrayList<JmsActor> actors = new ArrayList<JmsActor>();
                        for (String secretId : next.getValue()) {
                            sendSecretaryName.add(((ObjectNode)userMap.get(secretId)).get("fullname").asText());
                            JmsActor jmsActor = new JmsActor();
                            jmsActor.setId(secretId);
                            jmsActor.setEmail(JsonUtil.getString((JsonNode)((JsonNode)userMap.get(secretId)), (String)"email"));
                            jmsActor.setMobile(JsonUtil.getString((JsonNode)((JsonNode)userMap.get(secretId)), (String)"mobile"));
                            jmsActor.setWeixin(JsonUtil.getString((JsonNode)((JsonNode)userMap.get(secretId)), (String)"weixin"));
                            jmsActor.setClientId(JsonUtil.getString((JsonNode)((JsonNode)userMap.get(secretId)), (String)"clientId"));
                            jmsActor.setClientToken(JsonUtil.getString((JsonNode)((JsonNode)userMap.get(secretId)), (String)"clientToken"));
                            actors.add(jmsActor);
                        }
                        this.sendMsg(subject, reminder, text, html, actors, vars);
                    }
                    userNames = userNames + StringUtil.join(sendSecretaryName);
                }
            }
        }
        this.sendMsg("\u4efb\u52a1\u50ac\u529e", reminder, text, html, MessageUtil.parseJmsActor(recievers), vars);
        this.createReminderHistory(reminder, "sendMsg", "\u5411[" + userNames + "]\u53d1\u9001\u50ac\u529e\u6d88\u606f\u6210\u529f\uff01", task);
    }

    @Transactional
    private void sendMsg(String subject, BpmTaskReminder reminder, String text, String html, List<JmsActor> reciever, Map<String, Object> vars) {
        NoticeMessageType[] messageTypes = MessageUtil.parseNotifyType(reminder.getMsgType());
        ApplicationFeignService applicationFeignService = (ApplicationFeignService)AppUtil.getBean(ApplicationFeignService.class);
        for (NoticeMessageType type : messageTypes) {
            Notice notice;
            if (type.isPlain().booleanValue()) {
                notice = new Notice();
                notice.setSubject(subject);
                notice.setReceiver(reciever);
                notice.setContent(text);
                notice.setMessageTypes(new NoticeMessageType[]{type});
                notice.setVars(vars);
                applicationFeignService.sendNoticeToQueue(notice);
                continue;
            }
            notice = new Notice();
            notice.setSubject(subject);
            notice.setReceiver(reciever);
            notice.setContent(html);
            notice.setMessageTypes(new NoticeMessageType[]{type});
            notice.setVars(vars);
            applicationFeignService.sendNoticeToQueue(notice);
        }
    }

    @Transactional
    private void createReminderHistory(BpmTaskReminder reminder, String type, String msg, DefaultBpmTask task) {
        BpmReminderHistory history = new BpmReminderHistory();
        history.setExecuteDate(reminder.getDueDate());
        history.setNodeId(task.getNodeId());
        history.setNodeName(task.getName());
        history.setInstId(task.getProcInstId());
        history.setIsntName(task.getSubject());
        history.setRemindType(type);
        history.setNote(msg);
        history.setUserId(task.getOwnerId());
        history.setId(UniqueIdUtil.getSuid());
        history.setTaskId(task.getTaskId());
        this.bpmReminderHistoryManager.create((Model)history);
    }
}

