/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.manager.impl;

import com.artfess.base.handler.MultiTenantHandler;
import com.artfess.base.handler.MultiTenantIgnoreResult;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.uc.dao.OrgParamsDao;
import com.artfess.uc.dao.ParamsDao;
import com.artfess.uc.dao.UserParamsDao;
import com.artfess.uc.exception.RequiredException;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.manager.ParamsManager;
import com.artfess.uc.manager.UserManager;
import com.artfess.uc.model.Org;
import com.artfess.uc.model.OrgParams;
import com.artfess.uc.model.Params;
import com.artfess.uc.model.User;
import com.artfess.uc.model.UserParams;
import com.artfess.uc.params.params.ParamVo;
import com.artfess.uc.util.OrgUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ParamsManagerImpl
extends BaseManagerImpl<ParamsDao, Params>
implements ParamsManager {
    @Autowired
    UserParamsDao userParamsDao;
    @Autowired
    OrgParamsDao orgParamsDao;
    @Autowired
    UserManager userManager;
    @Autowired
    OrgManager orgManager;
    private static final List<String> types = Arrays.asList("1", "2", "3");
    private static final List<String> ctrTypes = Arrays.asList("input", "select", "checkbox", "radio", "date", "number");

    @Override
    public Params getByAlias(String alias) {
        if (StringUtil.isEmpty((String)alias)) {
            throw new RequiredException("\u53c2\u6570\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Params param = ((ParamsDao)this.baseMapper).getByCode(alias);
        if (BeanUtils.isEmpty((Object)param)) {
            throw new RuntimeException("\u7f16\u7801\u4e3a\u3010" + alias + "\u3011\u7684\u53c2\u6570\u4e0d\u5b58\u5728!");
        }
        return param;
    }

    @Override
    public Params getByTeam(String alias, String tenantTypeId) {
        if (StringUtil.isEmpty((String)alias)) {
            throw new RequiredException("\u53c2\u6570\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtil.isEmpty((String)tenantTypeId)) {
            throw new RequiredException("\u79df\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Params param = ((ParamsDao)this.baseMapper).getByTeam(alias, tenantTypeId);
        if (BeanUtils.isEmpty((Object)param)) {
            throw new RuntimeException("\u7f16\u7801\u4e3a\u3010" + alias + "\u3011\u7684\u53c2\u6570\u4e0d\u5b58\u5728!");
        }
        return param;
    }

    @Override
    public List<Params> getByType(String type) {
        return ((ParamsDao)this.baseMapper).getByType(type);
    }

    @Transactional
    public void removeByIds(String ... ids) {
        for (String id : ids) {
            Params params = (Params)this.get((Serializable)((Object)id));
            this.userParamsDao.removeByAlias(params.getCode(), LocalDateTime.now());
            this.orgParamsDao.removeByAlias(params.getCode(), LocalDateTime.now());
        }
        super.removeByIds(ids);
    }

    @Override
    @Transactional
    public CommonResult<String> addParams(ParamVo param) throws Exception {
        if (((ParamsDao)this.baseMapper).getCountByCode(param.getCode()) > 0) {
            throw new RequiredException("\u6dfb\u52a0\u53c2\u6570\u5931\u8d25\uff0c\u53c2\u6570\u7f16\u7801\u3010" + param.getCode() + "\u3011\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\uff01");
        }
        if (StringUtil.isEmpty((String)param.getCode())) {
            throw new RequiredException("\u6dfb\u52a0\u53c2\u6570\u5931\u8d25\uff0c\u53c2\u6570\u7f16\u7801\u3010code\u3011\u5fc5\u586b\uff01");
        }
        if (StringUtil.isEmpty((String)param.getName())) {
            throw new RequiredException("\u6dfb\u52a0\u53c2\u6570\u5931\u8d25\uff0c\u53c2\u6570\u540d\u79f0\u3010name\u3011\u5fc5\u586b\uff01");
        }
        if (StringUtil.isEmpty((String)param.getCtrType())) {
            throw new RequiredException("\u6dfb\u52a0\u53c2\u6570\u5931\u8d25\uff0c\u53c2\u6570\u63a7\u4ef6\u7c7b\u578b\u3010ctrType\u3011\u5fc5\u586b\uff01");
        }
        if (StringUtil.isEmpty((String)param.getType())) {
            throw new RequiredException("\u6dfb\u52a0\u53c2\u6570\u5931\u8d25\uff0c\u53c2\u6570\u7c7b\u578b\u3010type\u3011\u5fc5\u586b\uff01");
        }
        String ctyType = param.getCtrType().trim();
        if (!ctrTypes.contains(ctyType)) {
            throw new RequiredException("\u6dfb\u52a0\u53c2\u6570\u5931\u8d25\uff0cctrType \u53c2\u6570\u53ea\u80fd\u4e3a\uff1ainput\uff1a\u624b\u52a8\u8f93\u5165\uff1b   select\uff1a\u4e0b\u62c9\u6846\uff1b checkbox\uff1a\u590d\u9009\u6846\uff1b  radio\uff1a\u5355\u9009\u6309\u94ae\uff1b  date\uff1a\u65e5\u671f\uff1b  number\uff1a\u6570\u5b57\uff1b");
        }
        if ("select".equals(ctyType) || "checkbox".equals(ctyType) || "radio".equals(ctyType)) {
            Iterator elements = param.getJson().elements();
            while (elements.hasNext()) {
                JsonNode next = (JsonNode)elements.next();
                if (next.size() >= 2) continue;
                throw new RequiredException("\u6dfb\u52a0\u53c2\u6570\u5931\u8d25\uff0cctrType \u53c2\u6570\u7c7b\u578b\u4e3a\uff1aselect\uff08\u4e0b\u62c9\u6846\uff09\u3001 checkbox\uff08\u590d\u9009\u6846\uff09\u3001  radio\uff08\u5355\u9009\u6309\u94ae\uff09\u65f6\uff0cjson\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
        Params params = ParamVo.parse(param);
        params.setId(UniqueIdUtil.getSuid());
        if (types.contains(params.getType())) {
            ArrayList<Params> list = new ArrayList<Params>();
            if (BeanUtils.isNotEmpty((Object)params.getTenantTypeId())) {
                String[] str = params.getTenantTypeId().split(",");
                for (int i = 0; i < str.length; ++i) {
                    Params entity = new Params();
                    entity = (Params)BeanUtils.cloneBean((Object)params);
                    entity.setId(UniqueIdUtil.getSuid());
                    entity.setTenantTypeId(str[i]);
                    list.add(entity);
                }
            } else {
                list.add(params);
            }
            this.saveBatch(list);
            return new CommonResult(true, "\u6dfb\u52a0\u53c2\u6570\u6210\u529f\uff01", (Object)"");
        }
        return new CommonResult(false, "\u6dfb\u52a0\u53c2\u6570\u5931\u8d25\uff01\u53c2\u6570\u7c7b\u578b\u4e0d\u5bf9\uff0c\u8bf7\u5728(\u7528\u6237\u53c2\u6570\uff1a1),(\u7ec4\u7ec7\u53c2\u6570 :2)\u9009\u62e9\u5176\u4e2d\u4e00\u4e2a\u6570\u5b57", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> deleteParams(String codes) throws Exception {
        if (StringUtil.isEmpty((String)codes)) {
            throw new RequiredException("\u53c2\u6570\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String[] codeArray = codes.split(",");
        StringBuilder str = new StringBuilder();
        ArrayList<String> idArray = new ArrayList<String>();
        boolean isTrue = false;
        for (String code : codeArray) {
            Params params = ((ParamsDao)this.baseMapper).getByCode(code);
            if (BeanUtils.isNotEmpty((Object)params)) {
                idArray.add(params.getId());
                isTrue = true;
                continue;
            }
            str.append(code);
            str.append("\uff0c");
        }
        if (BeanUtils.isNotEmpty(idArray)) {
            this.removeByIds(OrgUtil.toStringArray(idArray));
        }
        String msg = StringUtil.isEmpty((String)str.toString()) ? "\u5220\u9664\u53c2\u6570\u6210\u529f\uff01" : "\u90e8\u5206\u5220\u9664\u5931\u8d25\uff0c\u53c2\u6570\u7f16\u7801\uff1a" + str.toString() + "\u4e0d\u5b58\u5728\uff01";
        return new CommonResult(isTrue, msg, (Object)str.toString());
    }

    @Override
    @Transactional
    public CommonResult<String> deleteParamsByIds(String ids) {
        if (StringUtil.isEmpty((String)ids)) {
            throw new RequiredException("\u53c2\u6570id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String[] idArray = ids.split(",");
        StringBuilder str = new StringBuilder();
        ArrayList<String> idA = new ArrayList<String>();
        boolean isTrue = false;
        for (String id : idArray) {
            Params params = (Params)this.get((Serializable)((Object)id));
            if (BeanUtils.isNotEmpty((Object)params)) {
                idA.add(params.getId());
                isTrue = true;
                continue;
            }
            str.append(id);
            str.append("\uff0c");
        }
        if (BeanUtils.isNotEmpty(idA)) {
            this.removeByIds(OrgUtil.toStringArray(idA));
        }
        String msg = StringUtil.isEmpty((String)str.toString()) ? "\u5220\u9664\u53c2\u6570\u6210\u529f\uff01" : "\u90e8\u5206\u5220\u9664\u5931\u8d25\uff0c\u53c2\u6570\u7f16\u7801\uff1a" + str.toString() + "\u4e0d\u5b58\u5728\uff01";
        return new CommonResult(isTrue, msg, (Object)str.toString());
    }

    @Override
    @Transactional
    public CommonResult<String> updateParams(ParamVo paramVo) throws Exception {
        if (BeanUtils.isEmpty((Object)paramVo.getId())) {
            throw new RequiredException("\u66f4\u65b0\u53c2\u6570\u5931\u8d25\uff0c\u53c2\u6570\u4e3b\u952eID\u5fc5\u586b\uff01");
        }
        Params params = (Params)((ParamsDao)this.baseMapper).selectById((Serializable)((Object)paramVo.getId()));
        if (BeanUtils.isEmpty((Object)params)) {
            return new CommonResult(false, "\u66f4\u65b0\u53c2\u6570\u5931\u8d25\uff0c\u53c2\u6570\u4e3b\u952eID\u3010" + paramVo.getId() + "\u3011\u4e0d\u5b58\u5728\uff01", (Object)"");
        }
        Params paramsTwo = ((ParamsDao)this.baseMapper).getByTeam(paramVo.getCode(), paramVo.getTenantTypeId());
        if (BeanUtils.isNotEmpty((Object)paramsTwo) && !paramsTwo.getId().equals(params.getId())) {
            return new CommonResult(false, "\u66f4\u65b0\u53c2\u6570\u5931\u8d25\uff0c\u4fee\u6539\u7684\u79df\u6237\u7c7b\u578b\u5df2\u5b58\u5728\uff01", (Object)"");
        }
        if (StringUtil.isNotEmpty((String)paramVo.getName())) {
            params.setName(paramVo.getName());
        }
        if (StringUtil.isNotEmpty((String)paramVo.getTenantTypeId())) {
            params.setTenantTypeId(paramVo.getTenantTypeId());
        }
        if (StringUtil.isNotEmpty((String)paramVo.getCtrType())) {
            params.setCtlType(paramVo.getCtrType());
            String ctyType = paramVo.getCtrType().trim();
            if ("select".equals(ctyType) || "checkbox".equals(ctyType) || "radio".equals(ctyType)) {
                Iterator elements = paramVo.getJson().elements();
                while (elements.hasNext()) {
                    JsonNode next = (JsonNode)elements.next();
                    if (next.size() >= 2) continue;
                    throw new RequiredException("\u6dfb\u52a0\u53c2\u6570\u5931\u8d25\uff0cctrType \u53c2\u6570\u7c7b\u578b\u4e3a\uff1aselect\uff08\u4e0b\u62c9\u6846\uff09\u3001 checkbox\uff08\u590d\u9009\u6846\uff09\u3001  radio\uff08\u5355\u9009\u6309\u94ae\uff09\u65f6\uff0cjson\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
            }
            params.setJson(JsonUtil.toJson((Object)paramVo.getJson()));
        }
        this.update((Model)params);
        return new CommonResult(true, "\u66f4\u65b0\u53c2\u6570\u6210\u529f\uff01", (Object)"");
    }

    private UserParams getUserParamsByUser(User user, String code) {
        Params param = ((ParamsDao)this.baseMapper).getByCode(code);
        if (BeanUtils.isEmpty((Object)param) || BeanUtils.isNotEmpty((Object)param) && !"1".equals(param.getType())) {
            throw new RequiredException("\u7528\u6237\u53c2\u6570\u7f16\u7801\u3010" + code + "\u3011\u4e0d\u5b58\u5728\uff01");
        }
        UserParams userParams = this.userParamsDao.getByUserIdAndCode(user.getId(), code);
        if (BeanUtils.isEmpty((Object)userParams)) {
            userParams = new UserParams();
            userParams.setUserId(user.getId());
            userParams.setAlias(code);
        }
        return userParams;
    }

    @Override
    public UserParams getUserParamsByCode(String account, String code) throws Exception {
        if (StringUtil.isEmpty((String)account) || StringUtil.isEmpty((String)code)) {
            throw new RequiredException("\u7528\u6237\u8d26\u53f7\u6216\u7528\u6237\u53c2\u6570\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        User user = this.userManager.getByAccount(account);
        if (BeanUtils.isEmpty((Object)user)) {
            throw new RequiredException("\u7528\u6237\u8d26\u53f7\u3010" + account + "\u3011\u4e0d\u5b58\u5728\uff01");
        }
        return this.getUserParamsByUser(user, code);
    }

    @Override
    public UserParams getUserParamsById(String userId, String code) throws Exception {
        if (StringUtil.isEmpty((String)userId) || StringUtil.isEmpty((String)code)) {
            throw new RequiredException("\u7528\u6237ID\u6216\u7528\u6237\u53c2\u6570\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        User user = (User)this.userManager.get((Serializable)((Object)userId));
        if (BeanUtils.isEmpty((Object)user)) {
            throw new RequiredException(String.format("ID\u4e3a\u3010%s\u3011\u7684\u7528\u6237\u4e0d\u5b58\u5728\uff01", userId));
        }
        return this.getUserParamsByUser(user, code);
    }

    private OrgParams getOrgParamsByOrg(Org org, String code) {
        Params param = ((ParamsDao)this.baseMapper).getByCode(code);
        if (BeanUtils.isEmpty((Object)param) || BeanUtils.isNotEmpty((Object)param) && !"2".equals(param.getType())) {
            throw new RequiredException("\u7ec4\u7ec7\u53c2\u6570\u7f16\u7801\u3010" + code + "\u3011\u4e0d\u5b58\u5728\uff01");
        }
        OrgParams orgParams = this.orgParamsDao.getByOrgIdAndAlias(org.getId(), code);
        if (BeanUtils.isEmpty((Object)orgParams)) {
            orgParams = new OrgParams();
            orgParams.setOrgId(org.getId());
            orgParams.setAlias(code);
        }
        return BeanUtils.isEmpty((Object)orgParams) ? new OrgParams() : orgParams;
    }

    @Override
    public OrgParams getOrgParamsByCode(String orgCode, String code) throws Exception {
        if (StringUtil.isEmpty((String)orgCode) || StringUtil.isEmpty((String)code)) {
            throw new RequiredException("\u7ec4\u7ec7\u7f16\u7801\u6216\u7ec4\u7ec7\u53c2\u6570\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Org org = this.orgManager.getByCode(orgCode);
        if (BeanUtils.isEmpty((Object)org)) {
            throw new RequiredException("\u7ec4\u7ec7\u7f16\u7801\u3010" + orgCode + "\u3011\u4e0d\u5b58\u5728\uff01");
        }
        return this.getOrgParamsByOrg(org, code);
    }

    @Override
    public OrgParams getOrgParamsById(String orgId, String code) throws Exception {
        if (StringUtil.isEmpty((String)orgId) || StringUtil.isEmpty((String)code)) {
            throw new RequiredException("\u7ec4\u7ec7ID\u6216\u7ec4\u7ec7\u53c2\u6570\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Org org = (Org)this.orgManager.get((Serializable)((Object)orgId));
        if (BeanUtils.isEmpty((Object)org)) {
            throw new RequiredException(String.format("ID\u4e3a\u3010%s\u3011\u7684\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff01", orgId));
        }
        return this.getOrgParamsByOrg(org, code);
    }

    @Override
    public List<Params> getParamsByTime(String btime, String etime) throws Exception {
        QueryFilter queryFilter = OrgUtil.getDataByTimeFilter(btime, etime);
        return this.queryNoPage(queryFilter);
    }

    @Override
    public CommonResult<Boolean> isCodeExist(String code) throws Exception {
        boolean isExist;
        Params params = ((ParamsDao)this.baseMapper).getByCode(code);
        return new CommonResult(isExist, (isExist = BeanUtils.isNotEmpty((Object)params)) ? "\u8be5\u7528\u6237\u7ec4\u7ec7\u53c2\u6570\u7f16\u7801\u5df2\u5b58\u5728\uff01" : "", (Object)isExist);
    }

    @Override
    @Transactional
    public Integer removePhysical() {
        return ((ParamsDao)this.baseMapper).removePhysical();
    }

    @Override
    public List<Params> getByTenantTypeId(String tenantTypeId) {
        List<Params> params = new ArrayList<Params>();
        try (MultiTenantIgnoreResult setThreadLocalIgnore = MultiTenantHandler.setThreadLocalIgnore();){
            params = ((ParamsDao)this.baseMapper).getByTenantTypeId(tenantTypeId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return params;
    }

    @Override
    public PageList queryWithType(QueryFilter queryFilter) {
        return new PageList(((ParamsDao)this.baseMapper).queryWithType((IPage<Params>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<Params>)this.convert2Wrapper(queryFilter, this.currentModelClass())));
    }
}

