/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.security.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.security.manager.SecurityMachineManager;
import com.artfess.security.manager.SecurityPersonloginlimitManager;
import com.artfess.security.model.SecurityMachine;
import com.artfess.security.model.SecurityPersonloginlimit;
import com.artfess.security.vo.PersonloginlimitVo;
import com.baomidou.mybatisplus.core.metadata.IPage;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/uc/Machine/v1/"})
@Api(tags={"\u6d89\u5bc6\u8ba1\u7b97\u673a\u7ef4\u62a4"})
@ApiGroup(group={"group_uc"})
public class SecurityMachineController
extends BaseController<SecurityMachineManager, SecurityMachine> {
    @Resource
    SecurityPersonloginlimitManager personloginlimitService;

    @RequestMapping(value={"saveMachine"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u6216\u4fee\u6539\u6d89\u5bc6\u8ba1\u7b97\u673a", httpMethod="POST", notes="\u4fdd\u5b58\u6216\u4fee\u6539\u6d89\u5bc6\u8ba1\u7b97\u673a")
    public CommonResult<String> saveMachine(@ApiParam(name="model", value="\u6d89\u5bc6\u8ba1\u7b97\u673a\u4fe1\u606f") @RequestBody SecurityMachine machine) throws Exception {
        ((SecurityMachineManager)this.baseService).saveMachine(machine);
        return new CommonResult("\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @RequestMapping(value={"deleteBatchMachine"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u6d89\u5bc6\u8ba1\u7b97\u673a", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u6d89\u5bc6\u8ba1\u7b97\u673a\uff08id\u591a\u4e2a\u7528,\u53f7\u9694\u5f00\uff09")
    public CommonResult<String> deleteBatchMachine(@ApiParam(name="ids", value="\u5173\u8054\u8868ID") @RequestParam(required=true) String ids) throws Exception {
        List<String> idList = Arrays.asList(ids.split(","));
        if (idList != null && idList.size() > 0) {
            for (String machineId : idList) {
                this.personloginlimitService.deleteByMachineId(machineId);
            }
            boolean result = ((SecurityMachineManager)this.baseService).removeByIds(idList);
            if (!result) {
                return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5220\u9664\u5931\u8d25");
            }
            return new CommonResult("\u5220\u9664\u6210\u529f\uff01");
        }
        return new CommonResult("\u6ca1\u6709\u5220\u9664\u7684\u6570\u636e\uff01");
    }

    @RequestMapping(value={"updateMachineSn"}, method={RequestMethod.PUT}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636eID\u6279\u91cf\u4fee\u6539\u6392\u5e8f\u53f7", httpMethod="PUT", notes="\u6839\u636eID\u6279\u91cf\u4fee\u6539\u6392\u5e8f\u53f7")
    @ApiImplicitParam(name="map", value="key:\u529f\u80fdid,value:\u6392\u5e8f\u53f7", required=true)
    public CommonResult<String> updateMachineSn(@RequestBody HashMap<String, Integer> map) throws Exception {
        ((SecurityMachineManager)this.baseService).updateSequence(map);
        return new CommonResult("\u4fee\u6539\u6210\u529f\uff01");
    }

    @RequestMapping(value={"queryPersonloginlimitPage"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4eba\u5458\u5173\u8054\u8bbe\u5907 -- \u5206\u9875\u67e5\u8be2\u4eba\u5458\u5173\u8054\u6d89\u5bc6\u8bbe\u5907", httpMethod="POST", notes="\u5206\u9875\u67e5\u8be2\u4eba\u5458\u5173\u8054\u6d89\u5bc6\u8bbe\u5907")
    public PageList<PersonloginlimitVo> queryPersonloginlimitPage(@ApiParam(name="filter", value="\u67e5\u8be2\u53c2\u6570", required=true) @RequestBody QueryFilter filter) throws Exception {
        IPage<PersonloginlimitVo> list = this.personloginlimitService.queryPersonloginlimitPage((QueryFilter<SecurityPersonloginlimit>)filter);
        return new PageList(list);
    }

    @RequestMapping(value={"insertPersonloginlimit"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4eba\u5458\u5173\u8054\u8bbe\u5907 -- \u7ed1\u5b9a\u4eba\u5458\u6d89\u5bc6\u8ba1\u7b97\u673a", httpMethod="POST", notes="\u4eba\u5458\u5173\u8054\u8bbe\u5907 -- \u7ed1\u5b9a\u4eba\u5458\u6d89\u5bc6\u8ba1\u7b97\u673a, \u7528\u6237id\uff08\u591a\u4e2a\u7528,\u53f7\u9694\u5f00\uff09")
    public CommonResult<String> insertPersonloginlimit(@ApiParam(value="\u8bbe\u5907_ID") @RequestParam(required=true) String machineId, @ApiParam(value="\u6240\u9009\u7528\u6237\u7684Id,\u591a\u4e2a\u4ee5\u201c,\u201d\u9694\u5f00") @RequestParam(required=true) String userIds) throws Exception {
        return this.personloginlimitService.insertPersonloginlimit(machineId, userIds);
    }

    @RequestMapping(value={"deletePersonloginlimis"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4eba\u5458\u5173\u8054\u8bbe\u5907 -- \u6839\u636e\u5173\u8054id\u5220\u9664\u4eba\u5458\u4e0e\u6d89\u5bc6\u8ba1\u7b97\u673a\u5173\u8054", httpMethod="DELETE", notes="\u4eba\u5458\u5173\u8054\u8bbe\u5907 -- \u6839\u636e\u5173\u8054id\u5220\u9664\u4eba\u5458\u4e0e\u6d89\u5bc6\u8ba1\u7b97\u673a\u5173\u8054\uff08\u591a\u4e2a\u7528,\u53f7\u9694\u5f00\uff09")
    public CommonResult<String> deletePersonloginlimis(@ApiParam(name="ids", value="\u5173\u8054\u8868ID") @RequestParam(required=true) String ids) throws Exception {
        boolean result = this.personloginlimitService.removeByIds(Arrays.asList(ids.split(",")));
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5220\u9664\u5931\u8d25");
        }
        return new CommonResult("\u5220\u9664\u6210\u529f\uff01");
    }
}

