package com.artfess.sysConfig.persistence.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @Program: edp
 * @Date: 2021/3/2
 * @Author: ZQF
 * @Description: 系统字典级联信息表
 */
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "SysDictionaryCascade", description = "系统字典级联信息表")
@TableName("portal_sys_dictionary_cascade")
@Data
public class SysDictionaryCascade extends BaseModel<SysDictionaryCascade> {

    @ApiModelProperty(value = "主键ID")
    @TableId("ID_")
    private String id;

    @ApiModelProperty(value = "关联的字典成员ID")
    @TableField("DETAIL_ID_")
    private String detailId;

    @ApiModelProperty(value = "联动下级字典_ID")
    @TableField("LOWER_DIC_ID_")
    private String lowerDicId;

    @ApiModelProperty(value = "联动下级成员_ID")
    @TableField("LOWER_DETAIL_ID_")
    private String lowerDetailId;

}
