package com.artfess.sysConfig.persistence.model;
import com.artfess.base.jaxb.LocalDateTimeAdapter;
import com.artfess.base.model.Tree;
import org.apache.commons.lang.builder.ToStringBuilder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.xml.bind.annotation.*;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.artfess.base.entity.BaseModel;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * portal_sys_app_menu
 * <pre> 
 * 描述：portal_sys_app_menu 实体对象
 * 构建组：x7
 * 作者:qiuxd
 * 邮箱:qiuxd@jee-soft.cn
 * 日期:2020-08-21 10:12:58
 * 版权：广州宏天软件股份有限公司
 * </pre>
 */
@XmlRootElement(name = "sysAppMenu")
@XmlAccessorType(XmlAccessType.FIELD)
 @TableName("portal_sys_app_menu")
 @ApiModel(value = "SysAppMenu",description = "portal_sys_app_menu") 
public class SysAppMenu extends BaseModel<SysAppMenu> implements Tree {

	private static final long serialVersionUID = 1L;
	@XmlTransient
	@TableId("ID_")
	@ApiModelProperty(value="主键")
	protected String id;

	@XmlTransient
	@TableField("PARENT_ID_")
	@ApiModelProperty(value="父节点ID")
	protected String parentId; 
	
	@XmlAttribute(name = "name")
	@TableField("NAME_")
	@ApiModelProperty(value="菜单名称")
	protected String name; 
	
	@XmlAttribute(name = "alias")
	@TableField("ALIAS_")
	@ApiModelProperty(value="别名")
	protected String alias;

	@XmlAttribute(name = "content")
	@TableField("CONTENT_")
	@ApiModelProperty(value="别名")
	protected String content;

	@XmlAttribute(name = "type")
	@TableField("TYPE_")
	@ApiModelProperty(value="别名")
	protected Short type;

	@XmlAttribute(name = "sn")
	@TableField("SN_")
	@ApiModelProperty(value="排序")
	protected String sn;

	@XmlTransient
	@TableField("APP_ID_")
	@ApiModelProperty(value="APPID")
	protected String appId; 
	
	@XmlAttribute(name = "createTime")
	@XmlJavaTypeAdapter(LocalDateTimeAdapter.class)
	@TableField("CREATE_TIME_")
	@ApiModelProperty(value="创建时间")
	protected LocalDateTime createTime; 
	
	@XmlAttribute(name = "createBy")
	@TableField("CREATE_BY_")
	@ApiModelProperty(value="创建人")
	protected String createBy; 
	
	@XmlAttribute(name = "updateTime")
	@XmlJavaTypeAdapter(LocalDateTimeAdapter.class)
	@TableField("UPDATE_TIME_")
	@ApiModelProperty(value="更新时间")
	protected LocalDateTime updateTime; 
	
	@XmlAttribute(name = "updateBy")
	@TableField("UPDATE_BY_")
	@ApiModelProperty(value="更新人")
	protected String updateBy;

	@TableField(exist=false)
	protected List<SysAppMenu> children = new ArrayList<SysAppMenu>();

	@ApiModelProperty(name = "isParent", notes = "是否父节点")
	@TableField(exist=false)
	protected String isParent;// 是否有子节点数据
	
	
	public void setId(String id) {
		this.id = id;
	}
	
	/**
	 * 返回 主键
	 * @return
	 */
	public String getId() {
		return this.id;
	}
	public void setParentId(String parentId) {
		this.parentId = parentId;
	}
	
	/**
	 * 返回 父节点ID
	 * @return
	 */
	public String getParentId() {
		return this.parentId;
	}

	@Override
	public String getText() {
		return null;
	}

	@Override
	public List getChildren() {
		return children;
	}

	@Override
	public void setChildren(List list) {
		this.children = list;
	}

	@Override
	public void setIsParent(String isParent) {
		this.isParent = isParent;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	/**
	 * 返回 菜单名称
	 * @return
	 */
	public String getName() {
		return this.name;
	}
	public void setAlias(String alias) {
		this.alias = alias;
	}
	
	/**
	 * 返回 别名
	 * @return
	 */
	public String getAlias() {
		return this.alias;
	}
	public void setSn(String sn) {
		this.sn = sn;
	}
	
	/**
	 * 返回 排序
	 * @return
	 */
	public String getSn() {
		return this.sn;
	}
	public void setAppId(String appId) {
		this.appId = appId;
	}
	
	/**
	 * 返回 APPID
	 * @return
	 */
	public String getAppId() {
		return this.appId;
	}
	public void setCreateTime(LocalDateTime createTime) {
		this.createTime = createTime;
	}
	
	/**
	 * 返回 创建时间
	 * @return
	 */
	public LocalDateTime getCreateTime() {
		return this.createTime;
	}
	public void setCreateBy(String createBy) {
		this.createBy = createBy;
	}
	
	/**
	 * 返回 创建人
	 * @return
	 */
	public String getCreateBy() {
		return this.createBy;
	}
	public void setUpdateTime(LocalDateTime updateTime) {
		this.updateTime = updateTime;
	}
	
	/**
	 * 返回 更新时间
	 * @return
	 */
	public LocalDateTime getUpdateTime() {
		return this.updateTime;
	}
	public void setUpdateBy(String updateBy) {
		this.updateBy = updateBy;
	}

	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}

	public Short getType() {
		return type;
	}

	public void setType(Short type) {
		this.type = type;
	}

	public String getIsParent() {
		return isParent;
	}

	/**
	 * 返回 更新人
	 * @return
	 */
	public String getUpdateBy() {
		return this.updateBy;
	}
	/**
	 * @see Object#toString()
	 */
	public String toString() {
		return new ToStringBuilder(this)
		.append("id", this.id) 
		.append("parentId", this.parentId) 
		.append("name", this.name) 
		.append("alias", this.alias) 
		.append("sn", this.sn) 
		.append("appId", this.appId) 
		.append("createTime", this.createTime) 
		.append("createBy", this.createBy) 
		.append("updateTime", this.updateTime) 
		.append("updateBy", this.updateBy) 
		.toString();
	}
}