package com.artfess.file.persistence.manager;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.manager.BaseManager;
import com.artfess.base.model.CommonResult;
import com.artfess.file.config.UploadResult;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.vo.FileReqVo;
import com.artfess.file.vo.MultipartCompleteParam;
import com.artfess.file.vo.MultipartInitParam;
import com.artfess.file.vo.MultipartInitRespVo;
import com.artfess.uc.api.model.IUser;
import com.google.gson.JsonObject;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public interface FileManager extends BaseManager<DefaultFile> {
	/**
	 * 根据附件格式获取附件
	 * @param allowFiles
	 * @return
	 */
	List<DefaultFile> getAllByExt(String[] allowFiles);
	/**
	 * 删除附件及附件表中的记录
	 * @param ids
	 * @throws Exception
	 */
	void delSysFileByIds(String[] ids) throws Exception;

	/**
	 * 通过附件配置上传
	 * @param file 附件对象
	 * @param files 上传的文件流
	 * @param bizCode 附件配置编码
	 * @param bizId 业务ID
	 * @param currentUser 当前用户
	 * @return
	 * @throws Exception
	 */
	UploadResult UploadFileForConfig(DefaultFile file, List<MultipartFile> files, String bizCode,String bizId,String bizType, IUser currentUser) throws Exception;

	/**
	 * 附件上传
	 * @param file 附件对象
	 * @param files 上传的文件流
	 * @param fileFormates 格式限定
	 * @param currentUser 当前用户
	 * @param flowKey 流程key
	 * @return
	 * @throws Exception
	 */
	UploadResult uploadFile(DefaultFile file, List<MultipartFile> files, String fileFormates, IUser currentUser,String flowKey) throws Exception;
	/**
	 * 附件上传
	 * @param file			附件对象
	 * @param inputStream	附件输入流
	 * @throws Exception
	 */
	void uploadFile(DefaultFile file, InputStream inputStream) throws Exception;
	/**
	 * 附件的下载
	 * @param fileId		附件ID
	 * @param outStream		附件输出流
	 * @return
	 * @throws Exception
	 */
	DefaultFile downloadFile(String fileId, OutputStream outStream) throws Exception;


	/**
	 * 设置附件分类
	 * @param fileId
	 * @param xbTypeId
	 * @throws Exception
	 */
	void setXbTypeId( List<String> fileId, String xbTypeId,String type) throws Exception;

	void updateFileExtraProp(List<DefaultFile> files);

	byte[] getFileBytesById(String fileId) throws Exception;

	void downloadFileToPath(DefaultFile file,String path) throws Exception;

	/**
     * 批量导入签章
     * @param file
     * @param isCover
     * @return
     */
    CommonResult<String> importSignature(MultipartFile file,boolean isCover);

	/**
	 * 根据文件长度与MD5值查询文件
	 * @param fileSize 文件长度
	 * @param md5Value 文件md5
	 * @Return: com.artfess.file.model.DefaultFile
	 * @Author: chens
	 * @Date: 2021/12/30 17:41
	 */
	DefaultFile queryByMd5AndSize(MultipartInitParam initParam);

    DefaultFile getFileInfo(FileReqVo fileReqVo);

	/**
	 * 根据附件ID更新BizId
	 * @param idList 文件ID集合
	 * @param bizId 业务数据ID
	 */
	void updateFileBizIdByIds(List<String> idList, String bizId);

	/**
	 * 根据附件ID更新BizId
	 * @param idList 文件ID集合
	 * @param bizId 业务数据ID
	 */
	void updateFileBizIdByIds(List<String> idList, String bizId, String bizCode);


	/**
	 * 根据BizId查询附件集合
	 * @param bizId bizId 关联数据id
	 * @return
	 */
	List<DefaultFile> queryFileByBizId(String bizId);

	/**
	 * 根据BizId查询附件集合
	 * @param bizId bizId 关联数据id
	 * @return
	 */
	List<DefaultFile> queryFileByBizId(String bizId, String bizCode);

	/**
	 * 根据BIZID移除文件
	 * @param bizId
	 */
	void removeFileByBizId(String bizId);

    String minioUrl(String fileId) throws Exception;

    MultipartInitRespVo initMultiPartUpload(MultipartInitParam requestParam);

	boolean chunkUpload(MultipartFile file, String uploadId, String chunk);

    UploadResult mergeMultipartUpload(MultipartCompleteParam param);

	JSONObject minioUpload(MultipartFile file, String bizPath , HttpServletResponse response) throws Exception;

	String minioPreviewFile(String bucketName, String fileName) throws Exception;

	String minioPreviewFile(String id) throws Exception;
}
