package com.artfess.file.config;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel(description="附件上传返回结果")
public class UploadResult {
    @ApiModelProperty(name="state",notes="状态 true：上传成功  false：上传失败")
    private boolean success;

    @ApiModelProperty("附件Id")
    private String fileId;

    @ApiModelProperty("附件名称")
    private String fileName;

    @ApiModelProperty("文件格式")
    private String fileExt;

    @ApiModelProperty("文件大小")
    private Long size;

    @ApiModelProperty("上传人")
    private String username;

    @ApiModelProperty("视频时长（秒）")
    private Long videoTime;

    @ApiModelProperty(value = "文件类型 1视频 2文档 3表格 4 pdf文档 5图片 6压缩文件 7可执行文件 8其他")
    private String fileType;

    @ApiModelProperty("转换后的pdfId")
    private String pdfFileId;

    @ApiModelProperty("出错信息")
    private String message;

    @ApiModelProperty("是否合并，0未合并 1已合并")
    private String mergeStatus;

}
