package com.artfess.easyExcel.controller;


import com.artfess.easyExcel.util.excel.ExcelUtil;
import com.artfess.easyExcel.vo.UserVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * easyexcel测试
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-11-27
 */
@Slf4j
@RestController
public class DemoController {



//    /**
//     * 导出Excel[下载速度可能更快]（并发查询，串行写入）<br>
//     * 注意：实际应用中，pageSize和parallelNum参数不应对外开放，此处为方便测试，或pageSize需要设置上限，防止恶意用户传一个很大的pageSize值，而撑满内存。
//     * @param response 响应
//     * @throws IOException
//     */
//    @GetMapping("/exportExcel")
//    public void writeExcelForXParallel(HttpServletResponse response) throws IOException {
//        Integer pageSize = 10000;
//        Integer parallelNum = 10;
//        XExcelUtil.download(response, "测试并发查询导出").parallel(parallelNum).pageSize(pageSize)
//                .pageExcelWriter(UserVo.class, page -> baseService.test(queryFilter, pageSize));
//    }

    /**
     * easyExcel导入excel
     * @throws IOException
     */
    @PostMapping("/importExcel")
    public void importExcel(HttpServletResponse response, @RequestBody MultipartFile file) throws IOException {
        ExcelUtil.read(file.getInputStream(), UserVo.class, 1000, pageList -> {
            pageList.forEach(user -> {
                // 业务逻辑
            });
        }).sheet().doRead();
    }

}

