package com.artfess.bpm.engine.def.impl.handler;

import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import org.dom4j.Document;
import org.dom4j.Element;
import org.springframework.stereotype.Service;

import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.Dom4jUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.api.constant.BpmConstants;
import com.artfess.bpm.api.model.process.def.BpmDefinition;
import com.artfess.bpm.api.plugin.core.context.BpmPluginContext;
import com.artfess.bpm.api.plugin.core.context.PluginParse;
import com.artfess.bpm.engine.def.AbstractBpmDefXmlHandler;
import com.artfess.bpm.engine.def.DefXmlHandlerUtil;


/**
 * 流程插件如果处理节点插件。则传递节点ID。
 * <pre> 
 * 构建组：x5-bpmx-core
 * 作者：ray
 * 邮箱:zhangyg@jee-soft.cn
 * 日期:2014-7-11-下午5:10:55
 * 版权：广州宏天软件有限公司版权所有
 * </pre>
 */
@Service
public class PluginsBpmDefXmlHandler extends AbstractBpmDefXmlHandler<List<BpmPluginContext>> {

	@Override
	protected String getXml(String defId, String nodeId,
			List<BpmPluginContext> list) {
		String xml=getByPluginList(list);
		 
		BpmDefinition def= bpmDefinitionManager.getById(defId);
		String defXml=def.getBpmnXml();
		
		String xParentPath="//ext:extProcess";
		String xPath="//ext:extProcess/ext:extPlugins";
		
		if(StringUtil.isNotEmpty(nodeId)){
			xParentPath = "//ext:*[@bpmnElement='"+nodeId+"']";
			xPath = xParentPath+"/ext:extPlugins";
		}
		
		String rtnXml= DefXmlHandlerUtil.getXml(defXml, xml, xParentPath, xPath);
		return rtnXml;
		
	}

	
	private String getByPluginList(List<BpmPluginContext> list){
		if(BeanUtils.isEmpty(list)) return "";
		StringBuffer sb=new StringBuffer();
		sb.append("<ext:extPlugins xmlns:ext=\""+BpmConstants.BPM_XMLNS+"\">\n");
		for(BpmPluginContext ctx:list){
			if(!(ctx instanceof PluginParse)) continue;
				
			PluginParse parse=(PluginParse)ctx;
			sb.append(parse.getPluginXml());
			
		}
		
		sb.append("</ext:extPlugins>");
		
		return sb.toString();
		
	}
	
	/**
	 * 批量保存节点restful事件
	 * @param defId
	 * @param nodeRestMap
	 * @throws Exception
	 */
	public void saveNodeXml(String defId,Map<String,List<BpmPluginContext>> nodeRestMap) throws Exception {
		String xml=getXml(defId, nodeRestMap);
		updateXml(defId,xml);
	}
	
	private String getXml(String defId,Map<String,List<BpmPluginContext>> nodeRestMap) {
		BpmDefinition def = bpmDefinitionManager.getById(defId);
		String defXml = def.getBpmnXml();
		Element root = updateRoot(defXml);
		String rtnXml = "";
		Set<Entry<String, List<BpmPluginContext>>> entrySet = nodeRestMap.entrySet();
		for (Entry<String, List<BpmPluginContext>> entry : entrySet) {
			String nodeId = entry.getKey();
			List<BpmPluginContext> pluginContexts = entry.getValue();
			String xml = getByPluginList(pluginContexts);
			String xParentPath="//ext:extProcess";
			String xPath="//ext:extProcess/ext:extPlugins";
			if(StringUtil.isNotEmpty(nodeId)){
				xParentPath = "//ext:*[@bpmnElement='"+nodeId+"']";
				xPath = xParentPath+"/ext:extPlugins";
			}
			rtnXml= DefXmlHandlerUtil.getXml(root, xml, xParentPath, xPath);
			root = updateRoot(rtnXml);
		}
		return rtnXml;
	}
	
	private Element updateRoot(String rtnXml) {
		Document doc=Dom4jUtil.loadXml(rtnXml);
		Element root= doc.getRootElement();
		root.addNamespace("restFuls", "http://www.jee-soft.cn/bpm/plugins/execution/restFuls");
		return root;
	}
}
