/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.portal.controller;

import cn.hutool.json.JSON;
import cn.hutool.json.JSONUtil;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.webSocket.PushService;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.manager.SysTypeManager;
import com.artfess.sysConfig.persistence.model.SysDictionary;
import com.artfess.sysConfig.persistence.model.SysDictionaryDetail;
import com.artfess.sysConfig.vo.DictionaryDetailVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/sysDictionary/v1"})
@Api(tags={"\u7cfb\u7edf\u5b57\u5178"})
@ApiGroup(group={"group_system"})
public class SysDictionaryController
extends BaseController<SysDictionaryManager, SysDictionary> {
    @Resource
    SysDictionaryManager sysDictionaryManager;
    @Resource
    SysTypeManager sysTypeManager;
    @Resource
    PushService pushService;

    @RequestMapping(value={"listJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7cfb\u7edf\u5b57\u5178(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)", httpMethod="POST", notes="\u7cfb\u7edf\u5b57\u5178(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)")
    public PageList<SysDictionary> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<SysDictionary> queryFilter) throws Exception {
        QueryFilter filter = QueryFilter.build();
        List sysTypeList = this.sysTypeManager.listObjs();
        if (null != sysTypeList && sysTypeList.size() > 0) {
            queryFilter.addFilter("TREE_ID_", (Object)sysTypeList, QueryOP.IN);
            return this.sysDictionaryManager.query(queryFilter);
        }
        return new PageList();
    }

    @RequestMapping(value={"saveDictionary"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u5b57\u5178", httpMethod="POST", notes="\u4fdd\u5b58\u5b57\u5178")
    public CommonResult<String> saveDictionary(@ApiParam(name="sysDictionary", value="\u5b57\u5178\u5bf9\u8c61") @RequestBody SysDictionary sysDictionary) throws Exception {
        String msg = this.sysDictionaryManager.saveDictionary(sysDictionary);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("cmd", "dict");
        JSON parse = JSONUtil.parse(map);
        this.pushService.pushMsgToAll(parse.toString());
        return new CommonResult(true, msg, (Object)sysDictionary.getId());
    }

    @RequestMapping(value={"deleteDictionaries"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", httpMethod="POST", notes="\u6279\u91cf\u5220\u9664")
    public CommonResult<String> deleteDictionaries(@ApiParam(name="ids", value="Id\u96c6\u5408\uff0c\u4ee5,\u9694\u5f00") @RequestParam String ids) throws Exception {
        this.sysDictionaryManager.deleteDictionaries(ids);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("cmd", "dict");
        JSON parse = JSONUtil.parse(map);
        this.pushService.pushMsgToAll(parse.toString());
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"updateDictionariesStatus"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fee\u6539\u5b57\u5178\u72b6\u6001", httpMethod="POST", notes="\u4fee\u6539\u5b57\u5178\u72b6\u6001")
    public CommonResult<String> updateDictionariesStatus(@ApiParam(name="ids", value="Id\u96c6\u5408\uff0c\u4ee5,\u9694\u5f00") @RequestParam String ids, @ApiParam(name="status", value="\u72b6\u6001") @RequestParam Integer status) throws Exception {
        this.sysDictionaryManager.updateDictionariesStatus(ids, status);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("cmd", "dict");
        JSON parse = JSONUtil.parse(map);
        this.pushService.pushMsgToAll(parse.toString());
        return new CommonResult(true, "\u4fee\u6539\u6210\u529f");
    }

    @RequestMapping(value={"loadDictionaryById"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636eID\u8fd4\u56de\u5b57\u5178\u8be6\u60c5", httpMethod="POST", notes="\u6839\u636eID\u8fd4\u56de\u5b57\u5178\u8be6\u60c5")
    public SysDictionary loadDictionaryById(@ApiParam(name="id", value="\u4e3b\u952eID") @RequestParam String id) throws Exception {
        return this.sysDictionaryManager.loadDictionaryById(id);
    }

    @RequestMapping(value={"moveDictionaries"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u79fb\u52a8\u5b57\u5178", httpMethod="POST", notes="\u79fb\u52a8\u5b57\u5178")
    public CommonResult<String> moveDictionaries(@ApiParam(name="ids", value="Id\u96c6\u5408\uff0c\u4ee5,\u9694\u5f00") @RequestParam String ids, @ApiParam(name="treeId", value="\u516c\u5171\u6811ID") @RequestParam String treeId) throws Exception {
        this.sysDictionaryManager.moveDictionaries(ids, treeId);
        return new CommonResult(true, "\u79fb\u52a8\u6210\u529f");
    }

    @RequestMapping(value={"updateDictionariesSequence"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fee\u6539\u5b57\u5178\u6392\u5e8f\u53f7", httpMethod="POST", notes="\u4fee\u6539\u5b57\u5178\u6392\u5e8f\u53f7")
    public CommonResult<String> updateDictionariesSequence(@ApiParam(name="params", value="\u6392\u5e8f\u53c2\u6570\uff1aKey\uff1aID\uff0cValue\uff1a\u6392\u5e8f\u53f7") @RequestBody HashMap<String, Integer> params) throws Exception {
        this.sysDictionaryManager.updateDictionariesSequence(params);
        return new CommonResult(true, "\u6392\u5e8f\u5b8c\u6210");
    }

    @RequestMapping(value={"syncDictionaryRedis"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u540c\u6b65\u7f13\u5b58", httpMethod="POST", notes="\u540c\u6b65\u7f13\u5b58")
    public CommonResult<String> syncDictionaryRedis() throws Exception {
        this.sysDictionaryManager.syncDictionaryRedis();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("cmd", "dict");
        JSON parse = JSONUtil.parse(map);
        this.pushService.pushMsgToAll(parse.toString());
        return new CommonResult(true, "\u7f13\u5b58\u5df2\u66f4\u65b0");
    }

    @RequestMapping(value={"queryLowerDictionary"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u5b57\u5178\u503c\u7684id\u7ea7\u8054\u67e5\u8be2\u4e0b\u7ea7\u5b57\u5178", httpMethod="POST", notes="\u6839\u636e\u5b57\u5178\u503c\u7684id\u7ea7\u8054\u67e5\u8be2\u4e0b\u7ea7\u5b57\u5178")
    public List<SysDictionary> queryLowerDictionary(@ApiParam(name="detailId", value="Id\u96c6\u5408\uff0c\u4ee5,\u9694\u5f00") @RequestParam String detailId) throws Exception {
        return this.sysDictionaryManager.queryLowerDictionary(detailId);
    }

    @RequestMapping(value={"queryAllDictItems"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u5b57\u5178\u4fe1\u606f\uff08\u767b\u9646\u65f6\u7f13\u5b58\u5230\u524d\u53f0\uff09", httpMethod="POST", notes="\u67e5\u8be2\u6240\u6709\u5b57\u5178\u4fe1\u606f\uff08\u767b\u9646\u65f6\u7f13\u5b58\u5230\u524d\u53f0\uff09")
    public Map<String, List<DictionaryDetailVo>> queryAllDictItems() throws Exception {
        return this.sysDictionaryManager.queryAllDictItems();
    }

    @RequestMapping(value={"queryDictItemsByCode"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636ecodes\u67e5\u8be2\u5b57\u5178\u4fe1\u606f", httpMethod="POST", notes="\u6839\u636ecodes\u67e5\u8be2\u5b57\u5178\u4fe1\u606f")
    public Map<String, List<SysDictionaryDetail>> queryDictItemsByCode(@ApiParam(name="codes", value="code\u96c6\u5408\uff0c\u4ee5,\u9694\u5f00") @RequestParam String codes) throws Exception {
        return this.sysDictionaryManager.queryDictItemsByCode(codes);
    }

    @RequestMapping(value={"queryLowerDictionaryDetail"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7\u4e0a\u7ea7\u5b57\u5178\u9879\u7684\u503c\u4e0e\u5176\u4e0b\u7ea7\u7ea7\u8054\u5b57\u5178\u7684id\uff0c\u83b7\u53d6\u7ea7\u8054\u7684\u5b57\u5178\u9879\u6570\u636e", httpMethod="POST", notes="\u901a\u8fc7\u4e0a\u7ea7\u5b57\u5178\u9879\u7684\u503c\u4e0e\u5176\u4e0b\u7ea7\u7ea7\u8054\u5b57\u5178\u7684id\uff0c\u83b7\u53d6\u7ea7\u8054\u7684\u5b57\u5178\u9879\u6570\u636e")
    public List<SysDictionaryDetail> queryLowerDictionaryDetail(@ApiParam(name="dictLowerId", value="\u4e0b\u7ea7\u5b57\u5178id") @RequestParam String dictLowerId, @ApiParam(name="detailId", value="\u4e0a\u7ea7\u5b57\u5178\u503c\u7684id") @RequestParam String detailId) throws Exception {
        return this.sysDictionaryManager.queryLowerDictionaryDetail(dictLowerId, detailId);
    }
}

