/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.form.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.bo.persistence.manager.BoDefManager;
import com.artfess.form.model.Form;
import com.artfess.form.model.FormBusSet;
import com.artfess.form.persistence.dao.FormMetaDao;
import com.artfess.form.persistence.manager.FormBusSetManager;
import com.artfess.form.service.FormService;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/form/formBusSet/v1"})
@Api(tags={"\u8868\u5355\u4e1a\u52a1\u8bbe\u7f6e"})
@ApiGroup(group={"group_form"})
public class FormBusSetController
extends BaseController<FormBusSetManager, FormBusSet> {
    @Resource
    FormBusSetManager formBusSetManager;
    @Resource
    FormService formService;
    @Resource
    FormMetaDao bpmFormDefDao;
    @Resource
    BoDefManager bODefManager;

    @RequestMapping(value={"getJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8868\u5355\u4e1a\u52a1\u8bbe\u7f6e\u660e\u7ec6\u9875\u9762", httpMethod="POST", notes="\u8868\u5355\u4e1a\u52a1\u8bbe\u7f6e\u660e\u7ec6\u9875\u9762")
    public JsonNode getJson(@ApiParam(name="formKey", value="\u8868\u5355\u4e1a\u52a1\u8bbe\u7f6eKey") @RequestBody String formKey) throws Exception {
        if (StringUtil.isEmpty((String)formKey)) {
            return null;
        }
        FormBusSet formBusSet = this.formBusSetManager.getByFormKey(formKey);
        HashMap<String, FormBusSet> object = new HashMap<String, FormBusSet>();
        object.put("formBusSet", formBusSet);
        Form form = this.formService.getByFormKey(formKey);
        List<String> boIds = this.bpmFormDefDao.getBODefIdByFormId(form.getDefId());
        if (boIds.size() >= 1) {
            ObjectNode boJson = this.bODefManager.getBOJson(boIds.get(0));
            object.put("boJson", (FormBusSet)boJson);
        }
        return JsonUtil.toJsonNode(object);
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u8868\u5355\u4e1a\u52a1\u8bbe\u7f6e\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u8868\u5355\u4e1a\u52a1\u8bbe\u7f6e\u4fe1\u606f")
    public CommonResult save(@ApiParam(name="formBusSet", value="\u8868\u5355\u4e1a\u52a1\u8bbe\u7f6e\u5bf9\u8c61") @RequestBody FormBusSet formBusSet) throws Exception {
        String resultMsg = null;
        String id = formBusSet.getId();
        boolean rtn = this.formBusSetManager.isExist(formBusSet);
        if (rtn) {
            return new CommonResult(false, "\u4e1a\u52a1\u8bbe\u7f6e\u5df2\u5b58\u5728!", null);
        }
        if (StringUtil.isEmpty((String)id)) {
            formBusSet.setId(UniqueIdUtil.getSuid());
            this.formBusSetManager.create((Model)formBusSet);
            resultMsg = "\u6dfb\u52a0\u8868\u5355\u4e1a\u52a1\u8bbe\u7f6e\u6210\u529f";
        } else {
            this.formBusSetManager.update((Model)formBusSet);
            resultMsg = "\u66f4\u65b0\u8868\u5355\u4e1a\u52a1\u8bbe\u7f6e\u6210\u529f";
        }
        return new CommonResult(true, resultMsg, null);
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u8868\u5355\u4e1a\u52a1\u8bbe\u7f6e\u8bb0\u5f55", httpMethod="POST", notes="\u6279\u91cf\u5220\u9664\u8868\u5355\u4e1a\u52a1\u8bbe\u7f6e\u8bb0\u5f55")
    public CommonResult remove(@ApiParam(name="id", value="\u8868\u5355\u4e1a\u52a1\u8bbe\u7f6eID\u591a\u4e2aID\u7528,\u5206\u5272") @RequestBody String id) throws Exception {
        String[] aryIds = null;
        if (!StringUtil.isEmpty((String)id)) {
            aryIds = id.split(",");
        }
        this.formBusSetManager.removeByIds(aryIds);
        return new CommonResult(true, "\u5220\u9664\u8868\u5355\u4e1a\u52a1\u8bbe\u7f6e\u6210\u529f", null);
    }

    @RequestMapping(value={"createSqlList"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="", httpMethod="POST", notes="")
    public ObjectNode treeList(@ApiParam(name="", value="") @RequestBody String formKey) throws Exception {
        return ((FormBusSetManager)this.baseService).getTreeList(formKey);
    }
}

