/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.form.persistence.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.JsonUtil;
import com.artfess.bo.model.BoData;
import com.artfess.bo.model.BoDef;
import com.artfess.bo.model.BoEnt;
import com.artfess.bo.persistence.manager.BoDefManager;
import com.artfess.bo.util.BoUtil;
import com.artfess.form.model.Form;
import com.artfess.form.model.FormBusSet;
import com.artfess.form.model.FormMeta;
import com.artfess.form.persistence.dao.FormBusSetDao;
import com.artfess.form.persistence.manager.FormBusManager;
import com.artfess.form.persistence.manager.FormBusSetManager;
import com.artfess.form.persistence.manager.FormManager;
import com.artfess.form.persistence.manager.FormMetaManager;
import com.artfess.form.persistence.manager.FormRightManager;
import com.artfess.form.service.FormService;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="formBusSetManager")
public class FormBusSetManagerImpl
extends BaseManagerImpl<FormBusSetDao, FormBusSet>
implements FormBusSetManager {
    @Resource
    FormManager bpmFormManager;
    @Resource
    FormMetaManager bpmFormdefManager;
    @Resource
    FormRightManager bpmFormRightManager;
    @Resource
    FormBusManager formBusManager;
    @Resource
    FormService formService;
    @Resource
    BoDefManager bODefManager;

    @Override
    public FormBusSet getByFormKey(String formKey) {
        return ((FormBusSetDao)this.baseMapper).getByFormKey(formKey);
    }

    @Override
    public boolean isExist(FormBusSet formSet) {
        return ((FormBusSetDao)this.baseMapper).isExist(formSet) > 0;
    }

    @Override
    public ObjectNode getDetail(String id, boolean readonly, String formKey) throws Exception {
        FormBusSet formBusSet = this.getByFormKey(formKey);
        Form form = this.bpmFormManager.getMainByFormKey(formKey);
        FormMeta formDef = (FormMeta)this.bpmFormdefManager.get((Serializable)((Object)form.getDefId()));
        List<String> boCode = this.bpmFormdefManager.getBOCodeByFormId(formDef.getId());
        JsonNode permissionConf = this.bpmFormRightManager.getByFormKey(formKey, readonly);
        JsonNode permission = this.bpmFormRightManager.calcFormPermission(permissionConf);
        BoData boData = this.formBusManager.getBoData(boCode.get(0), id);
        ObjectNode json = JsonUtil.getMapper().createObjectNode();
        json.put("data", (JsonNode)BoUtil.toJSON((BoData)boData, (boolean)true));
        json.put("boCode", boCode.get(0));
        json.put("permission", permission);
        json.put("formHtml", form.getFormHtml());
        json.put("formBusSet", JsonUtil.toJson((Object)((Object)formBusSet)));
        return json;
    }

    @Override
    public ObjectNode getTreeList(String formKey) throws Exception {
        Form form = this.formService.getByFormKey(formKey);
        FormMeta formDef = (FormMeta)this.bpmFormdefManager.get((Serializable)((Object)form.getDefId()));
        List<String> boCode = this.bpmFormdefManager.getBOCodeByFormId(formDef.getId());
        BoDef boDef = this.bODefManager.getByAlias(boCode.get(0));
        BoEnt boEnt = boDef.getBoEnt();
        ObjectNode json = JsonUtil.getMapper().createObjectNode();
        json.put("name", form.getName() + "\u5217\u8868");
        json.put("alias", form.getFormKey() + "List");
        json.put("sql", " select * from " + boEnt.getTableName());
        json.put("dsName", boEnt.getDsName());
        ArrayList array = new ArrayList();
        HashMap<String, String> addBtn = new HashMap<String, String>();
        addBtn.put("name", "\u65b0\u589e");
        addBtn.put("inRow", "0");
        addBtn.put("triggerType", "href");
        addBtn.put("urlPath", "/form/formBus/" + formKey + "/edit");
        array.add(addBtn);
        HashMap<String, String> editBtn = new HashMap<String, String>();
        editBtn.put("name", "\u7f16\u8f91");
        editBtn.put("inRow", "1");
        editBtn.put("triggerType", "href");
        editBtn.put("urlPath", "/form/formBus/" + formKey + "/edit?id={id_}");
        array.add(editBtn);
        HashMap<String, String> getBtn = new HashMap<String, String>();
        getBtn.put("name", "\u660e\u7ec6");
        getBtn.put("inRow", "1");
        getBtn.put("triggerType", "href");
        getBtn.put("urlPath", "/form/formBus/" + formKey + "/get?id={id_}");
        array.add(getBtn);
        HashMap<String, String> export = new HashMap<String, String>();
        export.put("name", "\u5bfc\u51fa");
        export.put("inRow", "0");
        export.put("triggerType", "onclick");
        export.put("urlPath", "exports()");
        array.add(export);
        json.put("buttonDef", JsonUtil.toJsonNode(array));
        return json;
    }
}

