/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.util;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PinyinUtil {
    public static String getPinyin(String chinese) {
        return PinyinUtil.getPinyinZh_CN(PinyinUtil.convertStringByChinese(chinese));
    }

    public static String getPinyinToUpperCase(String chinese) {
        return PinyinUtil.getPinyinZh_CN(PinyinUtil.convertStringByChinese(chinese)).toUpperCase();
    }

    public static String getPinyinToLowerCase(String chinese) {
        return PinyinUtil.getPinyinZh_CN(PinyinUtil.convertStringByChinese(chinese)).toLowerCase();
    }

    public static String getPinyinFirstToUpperCase(String chinese) {
        return PinyinUtil.getPinyin(chinese);
    }

    private static HanyuPinyinOutputFormat getDefaultFormat() {
        HanyuPinyinOutputFormat format = new HanyuPinyinOutputFormat();
        format.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        format.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        format.setVCharType(HanyuPinyinVCharType.WITH_U_AND_COLON);
        return format;
    }

    private static Set<String> convertStringByChinese(String chinese) {
        char[] chars = chinese.toCharArray();
        if (chinese != null && !chinese.trim().equalsIgnoreCase("")) {
            char[] srcChar = chinese.toCharArray();
            String[][] temp = new String[chinese.length()][];
            for (int i = 0; i < srcChar.length; ++i) {
                char c = srcChar[i];
                if (String.valueOf(c).matches("[\\u4E00-\\u9FA5]+") || String.valueOf(c).matches("[\\u3007]")) {
                    try {
                        temp[i] = PinyinHelper.toHanyuPinyinStringArray((char)chars[i], (HanyuPinyinOutputFormat)PinyinUtil.getDefaultFormat());
                    }
                    catch (BadHanyuPinyinOutputFormatCombination e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                temp[i] = new String[]{String.valueOf(srcChar[i])};
            }
            String[] pingyinArray = PinyinUtil.exchange(temp);
            HashSet<String> pinyin = new HashSet<String>();
            pinyin.add(pingyinArray[0]);
            return pinyin;
        }
        return null;
    }

    private static String[] exchange(String[][] strJaggedArray) {
        String[][] temp = PinyinUtil.doExchange(strJaggedArray);
        return temp[0];
    }

    private static String[][] doExchange(String[][] strJaggedArray) {
        int len = strJaggedArray.length;
        if (len >= 2) {
            int len1 = strJaggedArray[0].length;
            int len2 = strJaggedArray[1].length;
            int newlen = len1 * len2;
            String[] temp = new String[newlen];
            int index = 0;
            for (int i = 0; i < len1; ++i) {
                for (int j = 0; j < len2; ++j) {
                    temp[index] = PinyinUtil.capitalize(strJaggedArray[0][i]) + PinyinUtil.capitalize(strJaggedArray[1][j]);
                    ++index;
                }
            }
            String[][] newArray = new String[len - 1][];
            for (int i = 2; i < len; ++i) {
                newArray[i - 1] = strJaggedArray[i];
            }
            newArray[0] = temp;
            return PinyinUtil.doExchange(newArray);
        }
        return strJaggedArray;
    }

    private static String capitalize(String s) {
        char[] ch = s.toCharArray();
        if (ch != null && ch.length > 0 && ch[0] >= 'a' && ch[0] <= 'z') {
            ch[0] = (char)(ch[0] - 32);
        }
        return new String(ch);
    }

    private static String getPinyinZh_CN(Set<String> stringSet) {
        StringBuilder str = new StringBuilder();
        int i = 0;
        for (String s : stringSet) {
            if (i == stringSet.size() - 1) {
                str.append(s);
            } else {
                str.append(s + ",");
            }
            ++i;
        }
        return str.toString();
    }

    public static String getPinYinHeadChar(String chinese) {
        StringBuffer pinyin = new StringBuffer();
        if (chinese != null && !chinese.trim().equalsIgnoreCase("")) {
            for (int j = 0; j < chinese.length(); ++j) {
                char word = chinese.charAt(j);
                String[] pinyinArray = PinyinHelper.toHanyuPinyinStringArray((char)word);
                if (pinyinArray != null) {
                    pinyin.append(pinyinArray[0].charAt(0));
                    continue;
                }
                pinyin.append(word);
            }
        }
        return pinyin.toString();
    }

    public static String strFilter(String str) throws PatternSyntaxException {
        String regEx = "[`~!@#$%^&*()+=|{}':;',\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f\"]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(str);
        return m.replaceAll("").trim();
    }

    public static String getPinYinHeadCharFilter(String chinese) {
        return PinyinUtil.strFilter(PinyinUtil.getPinYinHeadChar(chinese));
    }

    public static void main(String[] args) {
        Log logger = LogFactory.getLog(PinyinUtil.class);
        String str = "\u3007\u7684\u8f93\uffe5\uffe5#s\uff0cldsa";
        logger.error((Object)("\u5c0f\u5199\u8f93\u51fa\uff1a" + PinyinUtil.getPinyinToLowerCase(str)));
        logger.warn((Object)("\u5927\u5199\u8f93\u51fa\uff1a" + PinyinUtil.getPinyinToUpperCase(str)));
        logger.warn((Object)("\u9996\u5b57\u6bcd\u5927\u5199\u8f93\u51fa\uff1a" + PinyinUtil.getPinyinFirstToUpperCase(str)));
        logger.warn((Object)("\u8fd4\u56de\u4e2d\u6587\u7684\u9996\u5b57\u6bcd\u8f93\u51fa\uff1a" + PinyinUtil.getPinYinHeadChar(str)));
        logger.warn((Object)("\u8fd4\u56de\u4e2d\u6587\u7684\u9996\u5b57\u6bcd\u5e76\u8fc7\u6ee4\u7279\u6b8a\u5b57\u7b26\u8f93\u51fa\uff1a" + PinyinUtil.getPinYinHeadCharFilter(str)));
    }
}

