/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.enums;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public enum AreaLevelEnum {
    province("province", "\u7701"),
    city("city", "\u5e02"),
    country("country", "\u533a/\u53bf"),
    town("town", "\u4e61\u9547"),
    village("village", "\u6751");

    private String level;
    private String desc;

    private AreaLevelEnum(String level, String desc) {
        this.level = level;
        this.desc = desc;
    }

    public static List<String> townLevels() {
        ArrayList townLevels = Lists.newArrayList();
        townLevels.add(AreaLevelEnum.province.level);
        townLevels.add(AreaLevelEnum.city.level);
        townLevels.add(AreaLevelEnum.country.level);
        townLevels.add(AreaLevelEnum.town.level);
        return townLevels;
    }

    public static List<String> provinceTree() {
        ArrayList townLevels = Lists.newArrayList();
        townLevels.add(AreaLevelEnum.province.level);
        return townLevels;
    }

    public static String getDesc(String level) {
        AreaLevelEnum[] values;
        if (StringUtils.isEmpty((CharSequence)level)) {
            return null;
        }
        for (AreaLevelEnum state : values = AreaLevelEnum.values()) {
            if (!state.getLevel().equals(level)) continue;
            return state.getDesc();
        }
        return null;
    }

    public String getLevel() {
        return this.level;
    }

    public String getDesc() {
        return this.desc;
    }
}

