/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.util;

import com.artfess.base.datasource.DatabaseContext;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.StringUtil;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.extension.toolkit.JdbcUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SQLUtil {
    public static String getDbTypeByUrl(String url) {
        return JdbcUtils.getDbType((String)url).getDb();
    }

    public static String getDbType() {
        return SQLUtil.getDbTypeObj().getDb();
    }

    public static DbType getDbTypeObj() {
        DatabaseContext databaseContext = AppUtil.getBean(DatabaseContext.class);
        return databaseContext.getDbTypeObj();
    }

    public static boolean containsSqlInjection(String sql) {
        if (StringUtil.isEmpty(sql)) {
            return false;
        }
        Pattern pattern = Pattern.compile("\\b(insert|drop|grant|alter|delete|update|truncate)\\b");
        Matcher matcher = pattern.matcher(sql.toLowerCase());
        return matcher.find();
    }

    public static String ClobToString(Clob clob) throws SQLException, IOException {
        String ret = "";
        Reader read = clob.getCharacterStream();
        BufferedReader br = new BufferedReader(read);
        String s = br.readLine();
        StringBuffer sb = new StringBuffer();
        while (s != null) {
            sb.append(s);
            s = br.readLine();
        }
        ret = sb.toString();
        if (br != null) {
            br.close();
        }
        if (read != null) {
            read.close();
        }
        return ret;
    }
}

