/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.aop;

import com.artfess.base.aop.AopCacheHelper;
import com.artfess.base.exception.BaseException;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.AuthenticationUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class DataPermissionAspect {
    private Logger logger = LoggerFactory.getLogger(DataPermissionAspect.class);
    private static final String LOGIN_USER = "loginUser";
    private static final String LOGIN_USER_ORGS = "loginUserOrgs";
    private static final String LOGIN_USER_SUB_ORGS = "loginUserSubOrgs";
    private static final String CUSTOM_ORGS = "customOrgs";
    public static final String CREATE_BY_ = "CREATE_BY_";
    public static final String CREATE_ORG_ID_ = "CREATE_ORG_ID_";
    @Resource
    AopCacheHelper aopCacheHelper;

    @Around(value="execution(* *..*Controller.*(..)) && @annotation(com.artfess.base.annotation.DataPermission)")
    public Object dataPermission(ProceedingJoinPoint joinPoint) throws Throwable {
        Object[] params = joinPoint.getArgs();
        HttpServletRequest request = HttpUtil.getRequest();
        if (request == null) {
            return joinPoint.proceed();
        }
        String reqUri = request.getRequestURI();
        this.logger.debug(" \u8bf7\u6c42\u5730\u5740   " + reqUri);
        Set<String> currentUserRolesAlias = AuthenticationUtil.getCurrentUserRolesAlias();
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String alias : currentUserRolesAlias) {
            this.getDataPermission("DATA_PERMISSION" + alias + reqUri, map);
        }
        for (Object object : params) {
            if (!(object instanceof QueryFilter)) continue;
            QueryFilter filter = (QueryFilter)object;
            if (map.containsKey(CREATE_BY_)) {
                filter.addFilter(CREATE_BY_, map.get(CREATE_BY_).toString(), QueryOP.EQUAL, FieldRelation.OR, "dataPermission");
            }
            if (!map.containsKey(CREATE_ORG_ID_) || !BeanUtils.isNotEmpty(map.get(CREATE_ORG_ID_))) continue;
            filter.addFilter(CREATE_ORG_ID_, String.join((CharSequence)",", (Set)map.get(CREATE_ORG_ID_)), QueryOP.IN, FieldRelation.OR, "dataPermission");
        }
        AuthenticationUtil.setMapThreadLocal(map);
        Object process = joinPoint.proceed();
        AuthenticationUtil.removeMapThreadLocal();
        return process;
    }

    private void getDataPermission(String key, Map<String, Object> resultMap) {
        String dataPermission = this.aopCacheHelper.getDataPermissionFromCache(key);
        try {
            if (StringUtil.isEmpty(dataPermission)) {
                return;
            }
            ArrayNode createArrayNode = (ArrayNode)JsonUtil.toJsonNode(dataPermission);
            HashSet<String> orgIds = new HashSet<String>();
            for (JsonNode jsonNode : createArrayNode) {
                String type = jsonNode.get("type").asText();
                if (LOGIN_USER.equals(type) && !resultMap.containsKey(CREATE_BY_)) {
                    resultMap.put(CREATE_BY_, AuthenticationUtil.getCurrentUserId());
                }
                if (LOGIN_USER_ORGS.equals(type) && AuthenticationUtil.getCurrentUserOrgIds() != null) {
                    orgIds.add(AuthenticationUtil.getCurrentUserOrgIds());
                }
                if (LOGIN_USER_SUB_ORGS.equals(type) && AuthenticationUtil.getCurrentUserSubOrgIds() != null) {
                    orgIds.add(AuthenticationUtil.getCurrentUserSubOrgIds());
                }
                if (!CUSTOM_ORGS.equals(type)) continue;
                ArrayNode tmpArray = (ArrayNode)jsonNode.get("orgs");
                for (JsonNode tmpJsonNode : tmpArray) {
                    orgIds.add(tmpJsonNode.get("id").asText());
                }
            }
            resultMap.put(CREATE_ORG_ID_, orgIds);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new BaseException(" \u8f6c\u6362\u6570\u636e\u6743\u9650\u8bbe\u7f6e\u5931\u8d25\uff0c\u672a\u80fd\u6b63\u786e\u83b7\u53d6\u6570\u636e ", (Throwable)e);
        }
    }
}

