package com.artfess.zsj.home.model;

import com.artfess.base.entity.BizDelModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;

import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.List;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 系统工单表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2025-03-12
 */
@ApiModel(value="BizSystemWorkOrder对象", description="系统工单表")
@Data
@TableName("biz_system_work_order")
public class SystemWorkOrder extends BizDelModel<SystemWorkOrder> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "工单编号（系统自动生成）")
    @TableField("CODE_")
    private String code;

    @ApiModelProperty(value = "工单标题")
    @TableField("TITLE_")
    private String title;

    @ApiModelProperty(value = "所属模块（使用字典：1：智慧收费，2：智慧运行，3：智慧养护，4：智慧服务）")
    @TableField("MODULE_")
    private String module;

    @ApiModelProperty(value = "工单类型（使用字典，1：系统问题，2：使用帮助，3：业务需求，4：其他）")
    @TableField("TYPE_")
    private String type;

    @ApiModelProperty(value = "处理状态（使用字典，1：已提交，2：已受理，3：处理中，4：已处理，5：已关闭）")
    @TableField("HANDLING_STATUS_")
    private Integer handlingStatus;

    @ApiModelProperty(value = "紧急程度（使用字典，1：一般，2：较为紧急，3：非常紧急）")
    @TableField("URGENCY_")
    private Integer urgency;

    @ApiModelProperty(value = "处理方式（使用字典，1：现场运维部处理，2：:分发至研发部处理，3：反馈至客户处理，4：其他处理方式）")
    @TableField("HANDLING_METHOD_")
    private Integer handlingMethod;

    @ApiModelProperty(value = "计划完成时间")
    @TableField("PLANNED_COMPLETION_TIME_")
    private LocalDate plannedCompletionTime;

    @ApiModelProperty(value = "实际完成时间")
    @TableField("ACTUAL_COMPLETION_TIME_")
    private LocalDate actualCompletionTime;

    @ApiModelProperty(value = "处理步骤")
    @TableField("HANDLING_STEPS_")
    private String handlingSteps;

    @ApiModelProperty(value = "问题描述")
    @TableField("PROBLEM_DESCRIPTION_")
    private String problemDescription;

    @ApiModelProperty(value = "服务满意度")
    @TableField("SERVICE_SATISFACTION_")
    private Double serviceSatisfaction;

    @ApiModelProperty(value = "评价时间")
    @TableField("EVALUATION_TIME_")
    private LocalDateTime evaluationTime;

    @ApiModelProperty(value = "评价用户ID")
    @TableField("EVALUATION_USER_ID_")
    private String evaluationUserId;

    @ApiModelProperty(value = "评价用户")
    @TableField("EVALUATION_USER_NAME_")
    private String evaluationUserName;

    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Long version;

    @ApiModelProperty(value = "租户ID")
    @TableField("TENANT_ID_")
    private String tenantId;

    @ApiModelProperty(value = "系统工单处理记录")
    @TableField(exist = false)
    private List<SystemWorkOrderHandleLog> systemWorkOrderHandleLogList;

}
