package com.artfess.zsj.home.controller;


import com.aliyun.oss.common.utils.StringUtils;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.zsj.home.model.SystemWorkOrderHandleLog;
import com.artfess.zsj.home.manager.SystemWorkOrderHandleLogManager;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 系统工单处理记录表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2025-03-12
 */
@RestController
@RequestMapping("/home/systemWorkOrderHandleLog/v1/")
@Api(tags = "系统工单-处理记录")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_ZSJ})
public class SystemWorkOrderHandleLogController extends BaseController<SystemWorkOrderHandleLogManager, SystemWorkOrderHandleLog> {


    @PostMapping(value = "/queryListBySysWorkOrderId", produces = {"application/json; charset=utf-8"})
    @ApiOperation("根据工单ID查询处理记录")
    public List<SystemWorkOrderHandleLog> queryListBySysWorkOrderId(@ApiParam(name = "sysWorkOrderId", value = "系统工单ID") @RequestParam String sysWorkOrderId) {

        return baseService.queryListBySysWorkOrderId(sysWorkOrderId);
    }

    @DeleteMapping("/{sysWorkOrderId}")
    @ApiOperation("根据工单ID删除处理记录")
    public CommonResult<String> deleteBySysWorkOrderId(@ApiParam(name = "sysWorkOrderId", value = "系统工单ID") @PathVariable String sysWorkOrderId) {
        baseService.removeBySysWorkOrderId(sysWorkOrderId);
        return new CommonResult<>();
    }

}
