package com.artfess.zsj.home.model;

import com.artfess.base.entity.BizDelModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 系统工单处理记录表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2025-03-12
 */
@ApiModel(value="BizSystemWorkOrderHandleLog对象", description="系统工单处理记录表")
@Data
@TableName("biz_system_work_order_handle_log")
public class SystemWorkOrderHandleLog extends BizDelModel<SystemWorkOrderHandleLog> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "系统工单ID（关联系统工单表）")
    @TableField("SYSTEM_WORK_ORDER_ID_")
    private String systemWorkOrderId;

    @ApiModelProperty(value = "处理人")
    @TableField("HANDLING_USER_NAME_")
    private String handlingUserName;

    @ApiModelProperty(value = "处理时间")
    @TableField("BENCHMARK_PRICE_")
    private LocalDateTime benchmarkPrice;

    @ApiModelProperty(value = "处理状态（使用字典，1：提交，2：受理，3：处理中，4：已处理，5：关闭）")
    @TableField("HANDLING_STATUS_")
    private Integer handlingStatus;

    @ApiModelProperty(value = "整体进度(百分比)")
    @TableField("HANDLING_PROGRESS_")
    private Integer handlingProgress;

    @ApiModelProperty(value = "处理措施")
    @TableField("PROBLEM_DESCRIPTION_")
    private String problemDescription;

    @ApiModelProperty(value = "下一步计划")
    @TableField("NEXT_STEP_")
    private String nextStep;

    @ApiModelProperty(value = "当前问题")
    @TableField("CURRENT_ISSUES_")
    private String currentIssues;

    @ApiModelProperty(value = "进度更新人")
    @TableField("HANDLING_UPDATE_USER_NAME_")
    private String handlingUpdateUserName;

    @ApiModelProperty(value = "进度更新时间")
    @TableField("HANDLING_UPDATE_TIME_")
    private LocalDateTime handlingUpdateTime;

    @ApiModelProperty(value = "进度更新ID")
    @TableField("HANDLING_UPDATE_USER_ID_")
    private String handlingUpdateUserId;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Long version;

    @ApiModelProperty(value = "租户ID")
    @TableField("TENANT_ID_")
    private String tenantId;

}
