/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.zsj.application;

import com.aliyun.oss.common.utils.StringUtils;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.jwt.JwtTokenHandler;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.CommonUtil;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.redis.util.RedisUtil;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/application/server/"})
@Api(tags={"\u7b2c\u4e09\u65b9\u5e94\u7528\u8df3\u8f6c\u767b\u9646"})
@ApiGroup(group={"group_biz_zsj"})
public class AppDoorLoginController {
    @Resource
    private RedisUtil redisUtil;
    @Resource
    private JwtTokenHandler jwtTokenHandler;
    @Resource
    private UCFeignService uCFeignService;
    @Resource
    private UserDetailsService userDetailsService;
    private static final String TOKENKEY = "tokenKey";

    @RequestMapping(value={"generateTokenKey"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u751f\u6210tokenKey", httpMethod="GET", notes="\u751f\u6210tokenKey")
    public CommonResult generateTokenKey(HttpServletRequest request) {
        String uid = CommonUtil.createGUID();
        String token = HttpUtil.getRequest().getHeader("Authorization");
        if (StringUtil.isEmpty((String)token)) {
            new CommonResult(false, "\u8bf7\u6c42\u5934\u4e2d\u672a\u83b7\u53d6\u5230\u5408\u6cd5token\u4ee4\u724c");
        }
        token = token.replace("Bearer ", "");
        this.redisUtil.set("user.tokenKey." + uid, (Object)token, 300L);
        return new CommonResult(true, "\u63a5\u53e3\u8c03\u7528\u6210\u529f", (Object)uid);
    }

    @RequestMapping(value={"validateKeyAndGetToken"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u9a8c\u8bc1tokenkey\u5e76\u83b7\u53d6token\u4ee4\u724c", httpMethod="GET", notes="\u9a8c\u8bc1tokenkey\u5e76\u83b7\u53d6token\u4ee4\u724c")
    public CommonResult validateKeyAndGetToken(@ApiParam(name="tokenKey", value="tokenKey") @RequestParam(required=true) String tokenKey, HttpServletRequest request) {
        String redisKey = "user.tokenKey." + tokenKey;
        String token = (String)this.redisUtil.get(redisKey);
        if (StringUtils.isNullOrEmpty((String)token)) {
            return new CommonResult(false, "\u65e0\u6548\u7684tokenKey");
        }
        this.redisUtil.del(new String[]{redisKey});
        return new CommonResult(true, "\u63a5\u53e3\u8c03\u7528\u6210\u529f", (Object)token);
    }

    @RequestMapping(value={"validateKeyAndGetUser"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u9a8c\u8bc1tokenkey\u5e76\u83b7\u53d6\u7528\u6237\u4fe1\u606f", httpMethod="GET", notes="\u9a8c\u8bc1tokenkey\u5e76\u83b7\u53d6\u7528\u6237\u4fe1\u606f")
    public CommonResult validateKeyAndGetUser(@ApiParam(name="tokenKey", value="tokenKey") @RequestParam(required=true) String tokenKey, HttpServletRequest request) {
        String redisKey = "user.tokenKey." + tokenKey;
        String token = (String)this.redisUtil.get(redisKey);
        if (StringUtils.isNullOrEmpty((String)token)) {
            return new CommonResult(false, "\u65e0\u6548\u7684tokenKey");
        }
        request.setAttribute("Authorization", (Object)token);
        request.setAttribute("Proxy-Authorization", (Object)token);
        String userId = this.jwtTokenHandler.getUserIdFromToken(token);
        CommonResult userResult = this.uCFeignService.getUserById(userId);
        if (BeanUtils.isEmpty((Object)userResult)) {
            return new CommonResult(false, "\u7528\u6237\u4e0d\u5b58\u5728");
        }
        JsonNode userNode = (JsonNode)userResult.getValue();
        String account = JsonUtil.getString((JsonNode)userNode, (String)"account");
        String id = JsonUtil.getString((JsonNode)userNode, (String)"id");
        String status = JsonUtil.getString((JsonNode)userNode, (String)"status");
        String lockedStatus = JsonUtil.getString((JsonNode)userNode, (String)"lockedStatus");
        this.redisUtil.del(new String[]{redisKey});
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("account", account);
        map.put("userId", id);
        map.put("status", status);
        map.put("lockedStatus", lockedStatus);
        map.put("token", token);
        return new CommonResult(true, "\u63a5\u53e3\u8c03\u7528\u6210\u529f", map);
    }
}

