/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.persistence.model;

import com.artfess.base.entity.BaseModel;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.api.model.identity.BpmIdentity;
import com.artfess.bpm.api.model.process.task.BpmTask;
import com.artfess.bpm.api.model.process.task.SkipResult;
import com.artfess.bpm.persistence.model.AuthorizeRight;
import com.artfess.i18n.util.I18nUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.springframework.context.i18n.LocaleContextHolder;

@TableName(value="bpm_task")
public class DefaultBpmTask
extends BaseModel<DefaultBpmTask>
implements BpmTask,
Cloneable {
    private static final long serialVersionUID = 2240144872175803135L;
    @TableId(value="id_")
    protected String id;
    @TableField(value="name_")
    protected String name;
    @TableField(value="subject_")
    protected String subject;
    @TableField(value="task_id_")
    protected String taskId = "";
    @TableField(value="exec_id_")
    protected String execId;
    @TableField(value="node_id_")
    protected String nodeId;
    @TableField(value="proc_inst_id_")
    protected String procInstId;
    @TableField(value="proc_def_id_")
    protected String procDefId;
    @TableField(exist=false)
    protected String instIsForbidden;
    @TableField(value="proc_def_key_")
    protected String procDefKey;
    @TableField(value="proc_def_name_")
    protected String procDefName;
    @TableField(value="owner_id_")
    protected String ownerId = "0";
    @TableField(value="assignee_id_")
    protected String assigneeId = "0";
    @TableField(value="assignee_name_")
    protected String assigneeName = "";
    @TableField(value="owner_name_")
    protected String ownerName = "";
    @TableField(value="status_")
    protected String status;
    @TableField(value="priority_")
    protected Long priority;
    @TableField(value="due_time_")
    protected LocalDateTime dueTime;
    @TableField(value="suspend_state_")
    protected Short suspendState;
    @TableField(value="parent_id_")
    protected String parentId = "0";
    @TableField(value="bpmn_inst_id_")
    protected String bpmnInstId = "";
    @TableField(value="bpmn_def_id_")
    protected String bpmnDefId = "";
    @TableField(value="type_id_")
    protected String typeId = "";
    @TableField(value="is_read_")
    protected Integer isRead = null;
    @TableField(value="is_revoke_")
    protected Integer isRevoke = null;
    @TableField(value="prop1_")
    protected String prop1;
    @TableField(value="prop2_")
    protected String prop2;
    @TableField(value="prop3_")
    protected String prop3;
    @TableField(value="prop4_")
    protected String prop4;
    @TableField(value="prop5_")
    protected String prop5;
    @TableField(value="prop6_")
    protected String prop6;
    @TableField(value="support_mobile_")
    protected int supportMobile = 0;
    @TableField(value="create_time_")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    protected LocalDateTime createTime = LocalDateTime.now();
    @TableField(exist=false)
    protected LocalDate transDate;
    @TableField(exist=false)
    protected AuthorizeRight authorizeRight;
    @TableField(exist=false)
    protected transient boolean isIdentityEmpty = false;
    @TableField(exist=false)
    protected transient List<BpmIdentity> identityList = null;
    @TableField(exist=false)
    protected transient SkipResult skipResult = new SkipResult();
    @TableField(exist=false)
    protected transient LocalDateTime createDate;
    @TableField(exist=false)
    protected String creatorId;
    @TableField(exist=false)
    protected String creator;
    @TableField(exist=false)
    protected String instStatus;
    @TableField(exist=false)
    protected String leaderIds = "";
    @TableField(exist=false)
    protected boolean isGateway_ = false;
    @TableField(exist=false)
    protected String dueDateType;
    @TableField(exist=false)
    protected LocalDateTime dueExpDate;
    @TableField(exist=false)
    protected int dueTaskTime = 0;
    @TableField(exist=false)
    protected int dueUseTaskTime = 0;
    @TableField(exist=false)
    protected int dueStatus;
    @TableField(exist=false)
    protected String urgentStateValue;
    @TableField(exist=false)
    protected String isBpmTask;
    @TableField(exist=false)
    protected LocalDateTime deadline;

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return I18nUtil.replaceTemp((String)this.name, (String)"\\$\\$\\{([\\w]+[\\.\\w]*)\\}", (Locale)LocaleContextHolder.getLocale());
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    @Override
    public String getTaskId() {
        return this.taskId;
    }

    @Override
    public void setExecId(String execId) {
        this.execId = execId;
    }

    @Override
    public String getExecId() {
        return this.execId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    @Override
    public String getNodeId() {
        return this.nodeId;
    }

    public void setProcInstId(String procInstId) {
        this.procInstId = procInstId;
    }

    @Override
    public String getProcInstId() {
        return this.procInstId;
    }

    public void setProcDefId(String procDefId) {
        this.procDefId = procDefId;
    }

    @Override
    public String getProcDefId() {
        return this.procDefId;
    }

    public void setProcDefKey(String procDefKey) {
        this.procDefKey = procDefKey;
    }

    @Override
    public String getProcDefKey() {
        return this.procDefKey;
    }

    public void setProcDefName(String procDefName) {
        this.procDefName = procDefName;
    }

    @Override
    public String getProcDefName() {
        return this.procDefName;
    }

    @Override
    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    @Override
    public String getOwnerId() {
        return this.ownerId;
    }

    @Override
    public void setAssigneeId(String assigneeId) {
        this.assigneeId = assigneeId;
    }

    @Override
    public String getAssigneeId() {
        return this.assigneeId;
    }

    @Override
    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    public void setPriority(Long priority) {
        this.priority = priority;
    }

    @Override
    public Long getPriority() {
        return this.priority;
    }

    public void setDueTime(LocalDateTime dueTime) {
        this.dueTime = dueTime;
    }

    @Override
    public LocalDateTime getDueTime() {
        return this.dueTime;
    }

    public void setSuspendState(Short suspendState) {
        this.suspendState = suspendState;
    }

    @Override
    public Short getSuspendState() {
        return this.suspendState;
    }

    @Override
    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    @Override
    public String getBpmnInstId() {
        return this.bpmnInstId;
    }

    public void setBpmnInstId(String bpmnInstId) {
        this.bpmnInstId = bpmnInstId;
    }

    @Override
    public String getBpmnDefId() {
        return this.bpmnDefId;
    }

    public void setBpmnDefId(String bpmnDefId) {
        this.bpmnDefId = bpmnDefId;
    }

    public boolean isBpmnTask() {
        String execId = this.execId;
        return StringUtil.isNotEmpty((String)execId);
    }

    public String getDueDateType() {
        return this.dueDateType;
    }

    public void setDueDateType(String dueDateType) {
        this.dueDateType = dueDateType;
    }

    public LocalDateTime getDueExpDate() {
        return this.dueExpDate;
    }

    public void setDueExpDate(LocalDateTime dueExpDate) {
        this.dueExpDate = dueExpDate;
    }

    public int getDueTaskTime() {
        return this.dueTaskTime;
    }

    public void setDueTaskTime(int dueTaskTime) {
        this.dueTaskTime = dueTaskTime;
    }

    public int getDueUseTaskTime() {
        return this.dueUseTaskTime;
    }

    public void setDueUseTaskTime(int dueUseTaskTime) {
        this.dueUseTaskTime = dueUseTaskTime;
    }

    public int getDueStatus() {
        return this.dueStatus;
    }

    public void setDueStatus(int dueStatus) {
        this.dueStatus = dueStatus;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.id).append("name", (Object)this.name).append("subject", (Object)this.subject).append("taskId", (Object)this.taskId).append("execId", (Object)this.execId).append("nodeId", (Object)this.nodeId).append("procInstId", (Object)this.procInstId).append("procDefId", (Object)this.procDefId).append("procDefKey", (Object)this.procDefKey).append("procDefName", (Object)this.procDefName).append("ownerId", (Object)this.ownerId).append("assigneeId", (Object)this.assigneeId).append("status", (Object)this.status).append("priority", (Object)this.priority).append("createTime", (Object)this.createTime).append("createDate", (Object)this.createDate).append("creator", (Object)this.creator).append("createTime", (Object)this.createTime).append("dueTime", (Object)this.dueTime).append("suspendState", (Object)this.suspendState).toString();
    }

    public boolean equals(Object obj) {
        DefaultBpmTask task = (DefaultBpmTask)obj;
        return this.id.equals(task.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public Object clone() {
        DefaultBpmTask o = null;
        try {
            o = (DefaultBpmTask)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return o;
    }

    @Override
    public List<BpmIdentity> getIdentityList() {
        return this.identityList;
    }

    public void setIdentityList(List<BpmIdentity> identityList) {
        this.identityList = identityList;
    }

    @Override
    public void setSkipResult(SkipResult skipResult) {
        this.skipResult = skipResult;
    }

    @Override
    public SkipResult getSkipResult() {
        return this.skipResult;
    }

    public AuthorizeRight getAuthorizeRight() {
        return this.authorizeRight;
    }

    public void setAuthorizeRight(AuthorizeRight authorizeRight) {
        this.authorizeRight = authorizeRight;
    }

    @Override
    public boolean isIdentityEmpty() {
        return this.isIdentityEmpty;
    }

    public void setIdentityEmpty(boolean isIdentityEmpty) {
        this.isIdentityEmpty = isIdentityEmpty;
    }

    @Override
    public String getOwnerName() {
        return this.ownerName;
    }

    @Override
    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public String getAssigneeName() {
        return this.assigneeName;
    }

    @Override
    public void setAssigneeName(String assigneeName) {
        this.assigneeName = assigneeName;
    }

    public LocalDateTime getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(LocalDateTime createDate) {
        this.createDate = createDate;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getInstStatus() {
        return this.instStatus;
    }

    public void setInstStatus(String instStatus) {
        this.instStatus = instStatus;
    }

    public String getTypeId() {
        return this.typeId;
    }

    public void setTypeId(String typeId) {
        this.typeId = typeId;
    }

    public LocalDate getTransDate() {
        return this.transDate;
    }

    public void setTransDate(LocalDate transDate) {
        this.transDate = transDate;
    }

    public int getSupportMobile() {
        return this.supportMobile;
    }

    public void setSupportMobile(int supportMobile) {
        this.supportMobile = supportMobile;
    }

    @Override
    public void setIsGateWay(boolean isGateway) {
        this.isGateway_ = isGateway;
    }

    @Override
    public boolean isGateWay() {
        return this.isGateway_;
    }

    public String getInstIsForbidden() {
        return this.instIsForbidden;
    }

    public void setInstIsForbidden(String instIsForbidden) {
        this.instIsForbidden = instIsForbidden;
    }

    public String getUrgentStateValue() {
        return this.urgentStateValue;
    }

    public void setUrgentStateValue(String urgentStateValue) {
        this.urgentStateValue = urgentStateValue;
    }

    public String getLeaderIds() {
        return this.leaderIds;
    }

    public void setLeaderIds(String leaderIds) {
        this.leaderIds = leaderIds;
    }

    public String getProp1() {
        return this.prop1;
    }

    public void setProp1(String prop1) {
        this.prop1 = prop1;
    }

    public String getProp2() {
        return this.prop2;
    }

    public void setProp2(String prop2) {
        this.prop2 = prop2;
    }

    public String getProp3() {
        return this.prop3;
    }

    public void setProp3(String prop3) {
        this.prop3 = prop3;
    }

    public String getProp4() {
        return this.prop4;
    }

    public void setProp4(String prop4) {
        this.prop4 = prop4;
    }

    public String getProp5() {
        return this.prop5;
    }

    public void setProp5(String prop5) {
        this.prop5 = prop5;
    }

    public String getProp6() {
        return this.prop6;
    }

    public void setProp6(String prop6) {
        this.prop6 = prop6;
    }

    public String getIsBpmTask() {
        return this.isBpmTask;
    }

    public void setIsBpmTask(String isBpmTask) {
        this.isBpmTask = isBpmTask;
    }

    @Override
    public LocalDateTime getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public LocalDateTime getDeadline() {
        return this.deadline;
    }

    public void setDeadline(LocalDateTime deadline) {
        this.deadline = deadline;
    }
}

