export const indexList = [
  {
    name: 'EBITDA Margin同比变化',
    key: 'ebitda',
    g: '-5%~5%',
    y: '≥-20%且≦-5%\n或≦20%且≥5%',
    r: '≦-20%\n或≥20%',
    indexKey: 'accval',
    list: [
      { name: '截至当月', key: 'curval', type: 'rate' },
      { name: '去年同期', key: 'befval', type: 'rate' },
    ],
  },
  {
    name: '高速公路车流量同比变化率（全口径）',
    key: 'vehFlow',
    g: '≥-10%',
    y: '-30%~-10%',
    r: '≦-30%',
    indexKey: 'accval',
    list: [
      { name: '截至当月(万架次)', key: 'curval' },
      { name: '去年同期(万架次', key: 'befval' },
    ],
  },
  {
    name: '员工总人数',
    key: 'employeeNums',
    g: '<=95%',
    y: '95%~100%',
    r: '>100%',
    indexKey: 'accval',
    list: [
      { name: '实际数量', key: 'curval', type: 'count' },
      { name: '定编定岗数量', key: 'befval', type: 'count' },
    ],
  },
  {
    name: '收费站人数',
    key: 'personNums',
    g: '<=95%',
    y: '95%~100%',
    r: '>100%',
    indexKey: 'accval',
    list: [
      { name: '实际数量', key: 'curval', type: 'count' },
      { name: '定编定岗数量', key: 'befval', type: 'count' },
    ],
  },
  {
    name: '管理费用同比变化率（同口径）',
    key: 'manageAmount',
    g: '<=0',
    y: '0%~5%',
    r: '≥5%',
    indexKey: 'accval',
    list: [
      { name: '截至当月累计(万元)', key: 'curval' },
      { name: '去年同期累计(万元)', key: 'befval' },
    ],
  },
  {
    name: '管理费用完成比例',
    key: 'manageAmount2',
    g: '<=80%',
    y: '80%~90%',
    r: '>=90%',
    indexKey: 'accval',
    list: [
      { name: '截至当月累计(万元)', key: 'amount' },
      { name: '本年度KPI值(万元)', key: 'amountKpi' },
    ],
  },
  {
    name: '付现成本同比变化变化率（同口径）',
    key: 'outlayCost',
    g: '<=0',
    y: '0%~5%',
    r: '≥5%',
    indexKey: 'accval',
    list: [
      { name: '截至当月累计(万元)', key: 'curval' },
      { name: '去年同期(万元)', key: 'befval' },
    ],
  },
  {
    name: '付现成本完成比例',
    key: 'outlayCost2',
    g: '<=80%',
    y: '80%~90%',
    r: '>=90%',
    indexKey: 'accval',
    list: [
      { name: '截至当月累计(万元)', key: 'amount' },
      { name: '本年度KPI值(万元)', key: 'amountKpi' },
    ],
  },
  {
    name: '人工成本同比变化变化率（同口径）',
    key: 'personCost',
    g: '<=80%',
    y: '80%~90%',
    r: '>=90%',
    indexKey: 'accval',
    list: [
      { name: '截至当月累计(万元)', key: 'curval' },
      { name: '去年同期(万元)', key: 'befval' },
    ],
  },
  {
    name: '人工成本总额完成比例',
    key: 'personAmount',
    g: '<=80%',
    y: '80%~90%',
    r: '>=90%',
    indexKey: 'accval',
    list: [
      { name: '截至当月累计(万元)', key: 'amount' },
      { name: '本年度KPI值(万元)', key: 'amountKpi' },
    ],
  },
  {
    name: '利润总额达成率（全口径）',
    key: 'profitComf',
    g: '>=90%',
    y: '80%~90%',
    r: '<=80%',
    indexKey: 'amount',
    list: [
      { name: '截至当月累计(万元)', key: 'accval' },
      { name: '本年度KPI值(万元)', key: 'amountKpi' },
      { name: '去年同期(万元)', key: 'befval' },
    ],
  },
  {
    name: '营业收入达成率（全口径）',
    key: 'incomeComf',
    g: '>=90%',
    y: '80%~90%',
    r: '<=80%',
    indexKey: 'amount',
    list: [
      { name: '截至当月累计(万元)', key: 'accval' },
      { name: '本年度KPI值(万元)', key: 'amountKpi' },
      { name: '去年同期(万元)', key: 'befval' },
    ],
  },
  {
    name: '新投资公路项目的营业收入达成率',
    key: 'newIncomeComf',
    g: '≥80%',
    y: '60%-80%',
    r: '≦60%',
    indexKey: 'amount',
    list: [
      { name: '截至当月累计(万元)', key: 'accval' },
      { name: '去年同期值(万元)', key: 'befval' },
      { name: '可研本年度(万元)', key: 'amountKpi' },
    ],
  },
  {
    name: '新投资公路项目的利润总额达成率',
    key: 'newProfitComf',
    g: '≥80%',
    y: '60%-80%',
    r: '≦60%',
    indexKey: 'amount',
    list: [
      { name: '截至当月累计(万元)', key: 'accval' },
      { name: '去年同期值(万元)', key: 'befval' },
      { name: '可研本年度(万元)', key: 'amountKpi' },
    ],
  },
  {
    name: '新投资公路项目的净利润达成率',
    key: 'netProfitComf',
    g: '≥80%',
    y: '60%-80%',
    r: '≦60%',
    indexKey: 'amount',
    list: [
      { name: '截至当月累计(万元)', key: 'accval' },
      { name: '去年同期值(万元)', key: 'befval' },
      { name: '可研本年度(万元)', key: 'amountKpi' },
    ],
  },
]
