
export interface State {
    eventList: Array<Object>,
    eventSelected: Object,
    selectedCameraId: String,
    visibleStaticLayerCodes: Array<any>
}

const state: State = {
    eventList: [],
    eventSelected: {}, // 选中事件
    selectedCameraId: '',
    visibleStaticLayerCodes: ['TRAFFIC', 'DYNAMIC_TRAFFIC'],
}

const actions = {
    setEventList({ state, commit }: any, data: any) {
        commit('setEventList', data)
    },
    setEventSelected({ state, commit }: any, data: any) {
        commit('setEventSelected', data)
    },
    setSelectedCameraId({ state, commit }: any, data: any) {
        commit('setSelectedCameraId', data)
    }
}

const mutations = {
    setEventList: (state: State, eventList: any) => {
        state.eventList = eventList;
    },
    //设置选中事件经纬度
    setEventSelected: (state: State, eventSelected: any) => {
        if (eventSelected) {
            state.selectedCameraId = ''
        }
        state.eventSelected = eventSelected;
    },
    setSelectedCameraId: (state: State, cameraId: string) => {
        if (cameraId) {
            state.eventSelected = {}
        }
        state.selectedCameraId = cameraId
    },
    SET_STATE: (state: any, payload: any) => {
        state[payload.key] = payload.value
    }
}


export default {
    namespaced: true,
    state,
    actions,
    mutations,
}
