import { createWebHashHistory, createRouter } from "vue-router";
import { reactive } from "vue";
const urlList: any = reactive({
	value: JSON.parse(localStorage.getItem("url")),
});
export const routes = [
	{
		path: "/",
		component: () => import("@/layout/default.vue"),
		redirect: "/business",
		// redirect: urlList.value,
		children: [
			{
				name: "business",
				path: "/business",
				title: "业务概况",
				meta: {
					code: "LDJSC",
				},
				component: () => import("@/views/bussinessCopy/index.vue"),
			},
			{
				name: "manageGeneralSituation",
				path: "/manageGenera",
				title: "经营概况",
				meta: {
					code: "JY",
				},
				component: () =>
					import("@/views/manageGeneralSituation/index.vue"),
			},
			{
				name: "expressway",
				path: "/expressway",
				title: "服务区",
				meta: {
					code: "GS",
				},
				component: () => import("@/views/expressway/index.vue"),
			},
			{
				name: "patrolAndRescue",
				path: "/patrolAndRescue",
				title: "巡查救援",
				meta: {
					code: "XCJY",
				},
				component: () => import("@/views/patrolAndRescue/index.vue"),
			},
			{
				name: "operationOverview",
				path: "/operationOverview",
				title: "运行监测",
				meta: {
					code: "LDJSC",
				},
				component: () => import("@/views/operationOverview/index.vue"),
			},
			{
				name: "operationOverviewOld",
				path: "/operationOverviewOld",
				title: "运行监测",
				meta: {
					code: "LDJSC",
				},
				component: () =>
					import("@/views/roadVisualizationCopy/index.vue"),
			},
			{
				name: "videoSurveillance",
				path: "/videoSurveillance",
				title: "视频监控",
				meta: {
					code: "LDJSC",
				},
				component: () => import("@/views/videoSurveillance/index.vue"),
			},
			{
				name: "curingManageCopy",
				path: "/curingManageyh",
				title: "养护管理",
				meta: {
					code: "HY",
				},
				component: () => import("@/views/curingManage/index.vue"),
			},
			// 养护管理业务概况
			{
				name: "curingBusinessCopy",
				path: "/curingBusinessyh",
				title: "养护概况",
				meta: {
					code: "HY",
				},
				component: () => import("@/views/curingBussinessNew/index.vue"),
			},

			// 收费系统
			{
				name: "chargeCopy",
				path: "/charge",
				title: "收费系统",
				meta: {
					code: "SF",
				},
				component: () => import("@/views/charge/index.vue"),
			},
			{
				name: "electromechanicalMange",
				path: "/electromechanicalMange",
				title: "机电管理",
				meta: {
					code: "JD",
				},
				component: () =>
					import("@/views/electromechanicalMange/index.vue"),
			},
			{
				name: "electromechanicalOverview",
				path: "/electromechanicalOverview",
				title: "机电概况",
				meta: {
					code: "JD",
				},
				component: () => import("@/views/businessOverview/index.vue"),
			},
			{
				name: "dataMonitoring",
				path: "/data-monitor",
				title: "数据监控",
				meta: {
					code: "LDJSC",
				},
				component: () => import("@/views/dataMonitoring/index.vue"),
			},
		],
	},
];

const router = createRouter({
	history: createWebHashHistory(),
	scrollBehavior(to, from, savedPosition) {
		// 始终滚动到顶部
		return { top: 0 };
	},
	routes,
});

export default router;
