import cryptoJS from "crypto-js";

/**
 * AES 加密
 * @export
 * @param {string} message 加密信息
 * @param {string} secretKey 秘钥
 * @returns
 */
export function AESEncrypt(message, secretKey) {
  const key = cryptoJS.enc.Utf8.parse(secretKey);
  const iv = cryptoJS.enc.Utf8.parse(secretKey);
  const encrypted = cryptoJS.AES.encrypt(message, key, {
    iv: iv,
    mode: cryptoJS.mode.CBC,
    padding: cryptoJS.pad.Pkcs7,
  });
  //返回的是base64格式的密文
  return encrypted.toString();
}

/**
 * AES解密
 * @export
 * @param {string} encrypted 加密字符串
 * @param {string} secretKey 秘钥
 * @returns
 */
export function AESDecrypt(encrypted, secretKey) {
  const key = cryptoJS.enc.Utf8.parse(secretKey);
  const iv = cryptoJS.enc.Utf8.parse(secretKey);
  const decrypted = cryptoJS.AES.decrypt(encrypted, key, {
    iv: iv,
    mode: cryptoJS.mode.CBC,
    padding: cryptoJS.pad.Pkcs7,
  });
  return decrypted.toString(cryptoJS.enc.Utf8);
}
