# SvgIcon SVG图标组件
Svg图标组件基于[svg-sprite-loader](https://github.com/JetBrains/svg-sprite-loader#readme)实现的svg雪碧图图标显示组件。

> 使用前请确保正确引入svg雪碧图，并且名称必须为` icon-[name]` 的形式。可参考以下webpack配置
>
> ```json
> {
>     test: /\.svg$/,
>     use: [
>       {
>         loader: "svg-sprite-loader",
>         options: {
>           symbolId: "icon-[name]",
>         },
>       },
>     ]
> }

## 用法

### 基础用法

::: demo

```vue
<template>
	<SvgIcon iconClass="web-lib-icon-expand" />
</template>
```

::: 



### 自定义svg className

::: demo

```vue
<template>
	<SvgIcon iconClass="web-lib-icon-expand" className="custom-svg-icon" />
</template>

<style>
  .custom-svg-icon{
    font-size:80px;
    color: #389EFF;
  }
</style>
```

::: 

## Props

| 参数      | 说明               | 类型   | 可选值 | 默认值 |
| --------- | ------------------ | ------ | ------ | ------ |
| iconClass | svg图标名称        | string | -      | -      |
| className | 自定义svg元素class | string | -      | -      |
