# CollapsePanel 伸缩面板

伸缩面板通常用于展示固定大小的侧边栏面板，如可收起的消息列表，或其他任意形式的展示面板。

## 用法

#### 基础用法

::: demo

```vue
<template>
	<div class="container">
    <CollapsePanel>
      <el-aside class="aside" :style="{ width: '456px' }">
          这是一个伸缩面板
      </el-aside>
  	</CollapsePanel>
  </div> 
</template>
<style>
  .container{
    display:flex;
  }
  .aside {
    height: 400px;
    background: #003859;
	}
</style>
```

:::

### 默认收起

::: demo

```vue
<template>
	<div class="container">
    <CollapsePanel :collapse="true">
      <el-card>
        这是一个伸缩面板
      </el-card>
    </CollapsePanel>
  </div>
</template>

<style>
  .container{
    display:flex;
  }
  .aside {
    height: 400px;
    background: #003859;
	}
</style>
```

:::

### 标题

::: demo

```vue
<template >
  <div class="container">
    <CollapsePanel title="这里是标题">
      <el-card>
        这是一个伸缩面板
      </el-card>
    </CollapsePanel>
  </div>
</template>

<style>
  .container{
    display:flex;
  }
  .aside {
    height: 400px;
    background: #003859;
	}
</style>
```

:::

### 方向

::: demo

```vue
<template >
	<div>
    <CollapsePanel direction="right" class="collapse-panel">
      <el-card>
        这是一个伸缩面板
      </el-card>
    </CollapsePanel>
  </div>
</template>

<style>
  .aside {
    height: 400px;
    background: #003859;
	}
  .collapse-panel{
    float:right;
  }
</style>
```

:::

### 
