const { series, src, dest } = require("gulp");
const cleanCSS = require("gulp-clean-css");
const rename = require("gulp-rename");
const gulpSass = require("gulp-sass")(require('sass'));
const postcss = require("gulp-postcss");
const del = require("del");

// 清理文件
function clean() {
  return del("../lib/**/*", { force: true });
}

// 构建CSS
function buildCSS() {
  return src("../src/index.scss")
    .pipe(
      gulpSass({
        includePaths: [
          "node_modules",
          "../node_modules",
          "../../../node_modules",
        ],
      })
    )
    .pipe(postcss())
    .pipe(cleanCSS())
    .pipe(rename("index.css"))
    .pipe(dest("../lib"));
}

// 复制element-ui字体文件
function copyFonts() {
  return src("../../../node_modules/element-ui/lib/theme-chalk/fonts/*")
    .pipe(dest("../lib/fonts"))
    .pipe(dest("../src/fonts"));
}

exports.default = series(clean, copyFonts, buildCSS);
