import AudioPlayer from "./AudioPlayer";
import BaseChart from "./BaseChart";
import Breadcrumb from "./Breadcrumb";
import Checkboxs from "./Checkboxs";
import CheckboxsGroup from "./CheckboxsGroup";
import CollapsePanel from "./CollapsePanel";
import ColorLabel from "./ColorLabel";
import DragAndResizable from "./DragAndResizable";
import Empty from "./Empty";
import Hamburger from "./Hamburger";
import ImageViewer from "./ImageViewer";
import Import from "./Import";
import InfoGroup from "./InfoGroup";
import InfoTitle from "./InfoTitle";
import List from "./List";
import ListItem from "./ListItem";
import ListItemMeta from "./ListItemMeta";
import MutableList from "./MutableList";
import PDFViewer from "./PDFViewer";
import Radios from "./Radios";
import RadiosGroup from "./RadiosGroup";
import ResizableDialog from "./ResizableDialog";
import Selects from "./Selects";
import SeparatDateTimeRange from "./SeparatDateTimeRange";
import SvgIcon from "./SvgIcon";
import Tables from "./Tables";
import Tree from "./Tree";
import TreeSelect from "./TreeSelect";
import Upload from "./Upload";
import VideoPlayer from "./VideoPlayer";
import Viewer from "./Viewer";

const components = {
  AudioPlayer,
  BaseChart,
  Breadcrumb,
  Checkboxs,
  CheckboxsGroup,
  CollapsePanel,
  ColorLabel,
  DragAndResizable,
  Empty,
  Hamburger,
  ImageViewer,
  Import,
  InfoGroup,
  InfoTitle,
  List,
  ListItem,
  ListItemMeta,
  MutableList,
  PDFViewer,
  Radios,
  RadiosGroup,
  ResizableDialog,
  Selects,
  SeparatDateTimeRange,
  SvgIcon,
  Tables,
  Tree,
  TreeSelect,
  Upload,
  VideoPlayer,
  Viewer,
};

function install(Vue, opts) {
  if (install.installed) return;
  Object.keys(components).forEach(key => {
    Vue.component(key, components[key]);
  });
}

if (typeof window !== "undefined" && window.Vue) {
  install(window.Vue);
}

export {
  AudioPlayer,
  BaseChart,
  Breadcrumb,
  Checkboxs,
  CollapsePanel,
  ColorLabel,
  DragAndResizable,
  Empty,
  Hamburger,
  ImageViewer,
  Import,
  InfoGroup,
  InfoTitle,
  List,
  MutableList,
  PDFViewer,
  Radios,
  ResizableDialog,
  Selects,
  SeparatDateTimeRange,
  SvgIcon,
  Tables,
  Tree,
  TreeSelect,
  Upload,
  VideoPlayer,
  Viewer,
};

export default {
  install,
};
